//   
// rational number reconstruction
// Source: Davenport/Siret/Tournier, Computer algebra, p. 142

// given n, M, find a, b with a/b \equiv n (mod M)
// (more precisely, a \equiv bn (mod M))
//and a, b < sqrt(M)/2 if such
// a, b exist, or returns FAIL otherwise



numlib::reconstructRational:=
proc(n: DOM_INT, M: Type::PosInt): Type::Union("_exprseq", DOM_FAIL)
  local q, r, Q, R;
begin
  if n^2 < M/2 then
    return(n, 1);
  end_if;
  q:= M;
  r:= n;
  Q:= 0;
  R:= 1;
  while not iszero(r) do
    [Q, R]:= [R,  Q - (q div r) * R];
    [q, r]:= [r, modp(q, r)];
    
    if r^2 < M/2 then
      if R^2 < M/2 then
        if R<0 then 
          r:=-r;
          R:=-R;
        end;
        return(r, R);
      else
        return(FAIL);
      end_if;
    end_if;
  end_while;
  FAIL;
end_proc: