//     

/*---
numlib::sqrt2cfrac(d)  

d - integer

returns the continued fraction expansion of sqrt(d)

Friedrich Schwarz, 21.7.1997
---*/

numlib::sqrt2cfrac := proc(d)
  local delta, a0, v, w, m, V, W, A, Z, a;
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  elif domtype(d) <> DOM_INT or d < 1 then
    error("argument must be a positive integer");
  end_if;
  
  delta := sqrt(d);
  if domtype(delta) = DOM_INT then
    return([delta]);
  end_if;
  
  v := 0;
  w := 1;
  m := isqrt(d);
  a0 := floor(delta);
  V := a0*w;
  W := (d - V^2)/w;
  A := [];
  Z := [2*a0];
  while V <> v and W <> w do
    a := (V + m) div W;
    A := append(A,a);
    Z := [a].Z;
    v := V;
    w := W;
    V := a*w - v;
    W := (d - V^2) / w;
  end_while;
  if v = V then
    delete Z[1];
  end_if;
  [a0],A.Z
end_proc:

