// Friedrich Schwarz 28.8.1994 

/*--
sqrtmodp(a,p) -- calculates a square root modulo p
                using Daniel Shanks algorithm RESSOL
			  
a -- a quadratic residue modulo p
p -- an odd prime
--*/

// used to be ressol2 until version 2.5.3

numlib::sqrtmodp :=
proc(a,p)
  local m, v, w, x, y, z, alpha, Beta, temp;
begin
  if args(0) <> 2 then
    error("wrong number of arguments");
  elif domtype(a) <> DOM_INT then
    error("1st argument must be an integer");
  elif domtype(p) <> DOM_INT or p <= 2 then
    error("2nd argument must be a prime > 2");
  end_if;

  if modp(p,4) = 3 then
    return(powermod(a,(p+1)/4,p));
  end_if;
  z := 2;
  while numlib::jacobi(z,p) = 1 do
    z := z + 1;
  end_while;
  alpha := 0;
  m := p - 1;
  while modp(m, 2) = 0 do
    alpha := alpha + 1;
    m := m div 2;
  end_while;
  w := powermod(z,m,p);
  x := powermod(a,(m+1)/2,p);
  y := powermod(a,m,p);
  while y <> 1 do
    Beta := 1;
    temp := modp(y*y,p);
    while modp(temp,p) <> 1 do
      Beta := Beta + 1;
      temp := modp(temp*temp,p)
    end_while;
    v := powermod(w,2^(alpha - Beta - 1),p);
    w := modp(v*v,p);
    x := modp(v*x,p);
    y := modp(w*y,p);
    alpha := Beta;
  end_while;
  x;
end_proc:
