// Friedrich Schwarz 11.3.1994 

/*--
sumdivisors(a) - returns the sum of the positive divisors of a
a - non-zero integer

sumdivisor(a) is the same as sigma(a) and as sigma(a,1)

sumdivisor uses ifactor
--*/

numlib::sumdivisors := proc(a)
  local i, w;
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  elif not testtype(a,Type::Numeric) then
    return(procname(args()));
  elif domtype(a) <> DOM_INT then
    error("argument must be an integer");
  end_if;

  if a = 0 then
    0
  else
    w := stdlib::ifactor(a);
    _mult((w[2*i]^(w[2*i+1] + 1) - 1)/(w[2*i] - 1) $ i = 1..(nops(w)-1)/2)
  end_if
end_proc:

