/*++ ---------------- series.mu ---------------------
Description:
This file contains the main function for computing series solutions of ode's.

Functions:

 - used Parameter:

 - ode::series

See:

Example:
series(ode(diff(y(x),x)+sin(x)/x,y(x)),x=a)
series(ode(diff(y(x),x)-y(x)^2-x^2,y(x)),x=1)
series(ode({diff(y(x),x,x)-y(x)^2-x^2,y(0)=0},y(x)),x=0)
series(ode({y''(x)-y(x)^2-x^2,y(0)=0,D(y)(0)=3},y(x)),x=0)
series(ode(y''(x)-y(x)+sin(x)/x,y(x)),x)

++*/

ode::series:=
  proc(aa)  // ode(..),x=a,<order>  oder: eq,y(x),<inits>,x=a,<order>
            // ode(..),x,<order>    oder: eq,y(x),<inits>,x,<order>
    local components, icset, a, f, eq, Lhs, i, dmax, icl, e, res, ord, dir,
          solveOptions, odeOptions;
  begin
    
    solveOptions:= {};
    odeOptions:= {};
    
    components:=ode::getComponents(args());
    
    if type(components[-1]) = DOM_SET and 
       type(components[-2]) = DOM_SET then 
      odeOptions:= components[-1];
      solveOptions:= components[-2];
      components[nops(components)]:= null();
      components[nops(components)]:= null();
    end_if;
    
    // components = eq, y, x, inits, x=a <, order <, dir>>

    if domtype(aa)=ode then
      if args(0)>1 and domtype(components[5])=DOM_SET then
        error("Illegal arguments")
      elif args(0)=1 then
        error("Expansion point is missing")
      end_if
    elif nops(components)>4 and domtype(components[5])=DOM_SET then
      components[5]:=map(components[5],ode::makeInitialCondition,components[2],
                         components[3]); 
      if contains(components[5],FAIL) then
        error("Invalid initial conditions");
      end_if;
      delete components[4];
    end_if;
    // now: components = sys, depVars, indepVar, inits, <x < =a >> , <order>
    if domtype(components[1])=DOM_SET or nops(components[2])>1 then
      error("Only scalar equations are treated");
    end_if;
    if nops(components)=4 then
      error("Expansion point is missing");
    elif domtype(components[5])=DOM_IDENT and components[5]=components[3] then
      components[5]:=components[5]=0;
    elif testtype(components[5],Type::Equation(Type::Unknown,
                                               Type::Arithmetical))=TRUE 
      and lhs(components[5])=components[3] then
      // its ok
    else
      error("Expansion point is missing")
    end_if;
    if nops(components)>5 then
      if testtype(components[6],Type::PosInt)=FALSE then
        error("Order must be a positive integer")
      else
        ord:= components[6]
      end_if
    else
      ord:= ORDER
    end_if;
    if nops(components)>6 then
      if not contains({Undirected, Real, Left, Right}, components[7]) then
        error("Invalid direction")
      end_if;
      dir:= components[7]
    else
      // default
      dir:= Real
    end_if;
    
    // it remains to test the initial conditions:
    icset:={};
    a:=rhs(components[5]);
    f:=components[2];
    for eq in components[4] do
      Lhs:=op(eq,1);
      i:=0;
      if a<>op(Lhs) then
        error("Initial conditions and expansion point do not match")
      end_if;
      Lhs:=op(Lhs,0); // This should be f or D(...(D(f))...)
      case type(Lhs)
        of DOM_IDENT do break;
        of "D" do
          repeat
            Lhs:=op(Lhs);
            i:=i+1;
          until type(Lhs)<>"D"
          end_repeat;
          break;
        otherwise error("Invalid initial conditions")
      end_case;
      if f<>Lhs then
        error("Invalid initial conditions");
      end_if;
      icset:=icset union {[i,op(eq,2)]}; // [i,b] means (D@@i)(f)(a)=b
    end_for;
    // make appropriate initial condition list for ode::repdiff
    if icset<>{} then
      dmax:=max(op(map(icset,e->op(e,1))));
      icl:=[a,(D@@i)(f)(a) $i=0..dmax];
      (icl[op(e,1)+2]:=op(e,2)) $ e in icset;
    else
      icl:=[a];
    end_if;

    res:=ode::repdiff(components[1],f,components[3],icl, ord, dir, 
                      solveOptions,odeOptions);
    if res=FAIL then
      res:=ode::frobenius(components[1],f,components[3],icl, ord, dir, 
                          solveOptions, odeOptions)
    end_if;
    if res=FAIL then 
      if type(args(args(0))) = DOM_SET and type(args(args(0)-1)) = DOM_SET then
        return(hold(series)(args(1..args(0)-2)))
      else 
        return(hold(series)(args()))
      end_if;
    end_if;
    if res=FAIL then return(hold(series)(args()))
    else return(res)
    end_if:
      
  end_proc:
