/* 
   ode::vectorize(Ly, y, x, n)
   
   DETAILS: The function returns a list of *all* coefficients of 
            Ly: [a_0, a_1, ... a_n].

   EXAMPLES: 

     >> eq := 4*x^2*diff(y(x), x$2)+4*x*diff(y(x),x)-y(x):
     >> ode::vectorize(eq,y,x,2);   
                                           2
                              [-1, 4 x, 4 x ]
*/

ode::vectorize := proc(eq,y,x,n,solveOptions={},odeOptions={})
  local k, vars;
begin
  vars:= [diff(y(x), x$k) $ k=0..n ];
  eq:= poly(eq, vars);
  
  return([expr(coeff(eq, vars[k], 1)) $ k=1..n+1]);
end_proc:


