/* 
  =====================================
  METHODS FOR ODES EQUIDIMENSIONAL IN Y 
  =====================================

  REFERENCES: [1] D. Zwillinger: "Handbook of Differential Equations", 
                  Section 60 pp. 253

   ode::equidimensional_in_y(eq,y,x,n) solves the nth order ODE eq=0 for y(x)
     if it is equidimensional in y (cf Zwillinger chap. 48 p. 191)
     Input: eq is an expression, y,x are variables, n is the order
     Output: FAIL or a list of solutions

   EXAMPLES: 
     >> ode::equidimensional_in_y((1-x)*(y(x)*diff(y(x),x,x)-diff(y(x),x)^2)+
                                   x^2*y(x)^2,y,x,2);
*/

ode::equidimensional_in_y :=
proc(eq,_y,_x,n,solveOptions,odeOptions)
  local a, optIgnoreAnalyticConstraints;
begin
  optIgnoreAnalyticConstraints:= if has(solveOptions, IgnoreAnalyticConstraints) then 
                IgnoreAnalyticConstraints;
              else
                null();
              end_if;   a:= genident();
  // first substitute y by a*Y 
  if has(ode::normal(subs(eq,_y(_x)=a*_y(_x),EvalChanges)/eq),{_y,_x}) then
    return(FAIL);
  else
    userinfo(1,"equidimensional in y equation");
    //eq:=eval(subs(eq,_y(_x)=exp(u(_x))));
    eq:= subs(eq,_y(_x)=exp(_y(_x)),EvalChanges);
    userinfo(2,"new equation is",eq);
    sysassign(ode::depth,ode::depth+1);
    //eq:=ode::solve_eq(expand(eq),u,_x,{});
    //eq:= ode::solve_eq(expand(eq,optIgnoreAnalyticConstraints),_y,_x,{},solveOptions,odeOptions);
    eq:= ode::solve_eq(eq,_y,_x,{},solveOptions,odeOptions);
    sysassign(ode::depth,ode::depth-1);
    if has(eq,FAIL) then 
      return(FAIL)
    else 
      return(map(eq,exp));
    end_if;
  end_if;
  
end_proc:

