/*
curtz(n,x) generates the n-th Curtz polynomial in x

P_0 = 1
P_n = x*sum((-1)^q/(q+1)*P_{n-q-1},q=0..n-1)+(-1)^n/(n+1)
*/

orthpoly::curtz := proc(n,x)
local i, q, C, koeffs;
begin 
  if args(0) <> 2 then error("wrong number of arguments"); end_if;
  if not (domtype(n) = DOM_INT) then
     return(procname(args()));
  end_if;
  if n < 0 then error("1st argument must not be negative"); end_if;
  if not testtype(x, Type::Arithmetical) then
     error("illegal 2nd argument");
  end_if;
  if domtype(x) = DOM_IDENT or type(x)="_index"
  then case n
       of 0 do return(poly(1, [x]));
       otherwise 
               koeffs:= table(q= poly(x*(-1)^q/(q+1),[x]) $ q=0..n);
               C[0]:= poly(1,[x]);
               for i from 1 to n do
                   C[i]:= _plus(C[i-q-1]*koeffs[q] $ q=0..i-1)
                         + poly((-1)^i/(i+1), [x]);
               end_for:
               return(C[n]);
       end_case;
  else case n
       of 0 do return(1);
       otherwise
               koeffs:= table(q= x*(-1)^q/(q+1) $ q=0..n);
               C[0]:= 1;
               for i from 1 to n do
                   C[i]:= _plus(C[i-q-1]*koeffs[q] $ q=0..i-1)
                         + (-1)^i/(i+1);
                   C[i]:= expand(C[i]);
               end_for:
               return(C[n]);
      end_case;
  end_if;
end_proc:

/* ----  end of file ---- */
