//    
// tonner, 23/06/98 

/*++
output::CatContent -- Category of Content markup
++*/

/** Creating Content trees
 *
 *   This domain implements the infrastructure to create Content
 *   trees
 */

category output::CatContent
  category output::CatUtils;

    outputType := "Content";

    /*
     * token elements
     */
    Ccn;        // Content Number
    Cci;        // Content Identifier
    Ccsymbol;   // externally defined symbol (MathML 2.0)

    /*
     * basic content elements
     */
    Capply;     // apply function
    Creln;      // equation or relation  (MML 1.0; abandoned with MML 2.0)
    Cfn;        // user-defined function (MML 1.0; abandoned with MML 2.0)
    Cinterval;  // interval constructor
    Cinverse;   // functional inverse
    Csep;       // separator 
    Ccondition; // properties of an identifier
    Cdeclare;   // declaration
    Clambda;    // user defined functions (procedures)
    Ccompose;   // composition operator
    Cident;     // identity function
    Cdomain;    // domain of a function (MathML 2.0)
    Ccodomain;            //  (MathML 2.0)
    Cimage;               //  (MathML 2.0)
    Cdomainofapplication; //  (MathML 2.0)
    Cpiecewise;           //  (MathML 2.0)
    Cpiece;               //  (MathML 2.0)
    Cotherwise;           //  (MathML 2.0)

    /*
     * arithmetic, algebra and logic
     */
    Cquotient;
    Cfactorial;
    Cdivide;
    Cmax;
    Cmin;
    Cminus;
    Cplus;
    Cpower;
    Crem;
    Ctimes;
    Croot;
    Cgcd;
    Cand;
    Cor;
    Cxor;
    Cnot;
    Cimplies;
    Cforall;
    Cexists;
    Cabs;
    Cconjugate;
    Carg;          //  (MathML 2.0)
    Creal;         //  (MathML 2.0)
    Cimaginary;    //  (MathML 2.0)
    Clcm;          //  (MathML 2.0)
    Cfloor;        //  (MathML 2.0)
    Cceiling;      //  (MathML 2.0)

    /*
     * relations
     */
    Ceq;
    Cneq;  
    Cgt;
    Clt;
    Cgeq;
    Cleq;
    Cequivalent;   //  (MathML 2.0)
    Capprox;       //  (MathML 2.0)
    Cfactorof;     //  (MathML 2.0)

    /*
     * calculus and vector analysis
     */
    Cint;
    Cdiff;
    Cpartialdiff;
    Clowlimit;
    Cuplimit;
    Cbvar;
    Cdegree;
    Cdivergence;   //  (MathML 2.0)
    Cgrad;         //  (MathML 2.0)
    Ccurl;         //  (MathML 2.0)
    Claplacian;    //  (MathML 2.0)

    /*
     * theory of sets
     */
    Cset;
    Clist;
    Cunion;
    Cintersect;
    Cin;
    Cnotin;
    Csubset;
    Cprsubset;
    Cnotsubset;  
    Cnotprsubset;  
    Csetdiff;
    Ccard;              //  (MathML 2.0)
    Ccartesianproduct;  //  (MathML 2.0)

    /*
     * sequences and series
     */
    Csum;
    Cproduct;
    Climit;
    Ctendsto;

    /*
     * elementary classical functions
     */
    Cexp;     Cln;      Clog;
    Csin;     Ccos;     Ctan;     Csec;     Ccsc;     Ccot;
    Csinh;    Ccosh;    Ctanh;    Csech;    Ccsch;    Ccoth;
    Carcsin;  Carccos;  Carctan;  Carcsec;  Carccsc;  Carccot;
    Carcsinh; Carccosh; Carctanh; Carcsech; Carccsch; Carccoth;

    /*
     * statistics
     */
    Cmean;
    Csdev;
    Cvariance;
    Cmedian;
    Cmode;
    Cmoment;
    Cmomentabout;     //  (MathML 2.0)

    /*
     * linear algebra
     */
    Cvector;
    Cmatrix;
    Cmatrixrow;
    Cdeterminant;
    Ctranspose;
    Cselector;
    Cvectorproduct;      //  (MathML 2.0)
    Cscalarproduct;      //  (MathML 2.0)
    Couterproduct;       //  (MathML 2.0)

    /*
     * semantic mapping elements
     */
    Cannotation;
    Csemantics;
    // should be Cannotation-xml;  but this is not valid MuPAD syntax
    CannotationXml;      // name changed !!
    
    /*
     *  constants and symbol elements (all new in MathML 2.0)
     */
    Cintegers;
    Creals;
    Crationals;
    Cnaturalnumbers;
    Ccomplexes;
    Cprimes;
    Cexponentiale;
    Cimaginaryi;
    Cnotanumber;
    Ctrue;
    Cfalse;
    Cemptyset;
    Cpi;
    Ceulergamma;
    Cinfinity;
    
    /*
     *  MuPAD constants and functions
     */
    Cabbreviation;
    Cassign;
    CbesselI;
    CbesselJ;
    CbesselK;
    CbesselY;
    Cbeta;
    Cbinomial;
    Ccomprow;        // needed for doc 
    Cconcat;
    Cdilog;
    Cdirac;
    CellipticCE;
    CellipticCK;
    CellipticCPi;
    CellipticE;
    CellipticF;
    CellipticK;
    CellipticNome;
    CellipticPi;
    Cequiv;
    CequivMod;       // needed for doc
    CevalAt;
    CEQS;
    CEQS3;
    Cexprseq;        // for _exprseq
    Cfactorial2;
    Cfenced;         // needed for doc 
    Cfnest;          // _fnest:  f@@n
    CfresnelC;
    CfresnelS;
    CfuncDecl;       // needed for doc
    Cgamma;
    Chtranspose;
    Chypergeom;
    Cigamma;
    Cindex;
    CintPV;          // int with PrincipalValue
    CinverseMatrix;
    CjacobiAM;
    CjacobiCD;
    CjacobiCN;
    CjacobiCS;
    CjacobiDC;
    CjacobiDN;
    CjacobiDS;
    CjacobiNC;
    CjacobiND;
    CjacobiNS;
    CjacobiSC;
    CjacobiSD;
    CjacobiSN;
    CjacobiZeta;
    CkroneckerDelta;
    ClambertW;
    Clngamma;
    CmeijerG;
    Cnorm;
    Cpochhammer;
    Cpolylog;
    Cpsi;
    CquadraticMean;
    Crange;
    Crow;
    Cseqgen;
    Cseqstep;
    Cseqin;
    Cslot;
    Ctable;
    Ctableau;
    Cunknown;        // the boolean constant UNKNOWN
    CUnion;
    Cunit;
    CwhittakerM;
    CwhittakerW;
    CwrightOmega;
    Czeta;

    
    /* common functions */
    
    
    statement := () -> error("not yet implemented");
      
    // print a standard function f(a,b)
    stdFunc :=
    proc()
      local arg1;
    begin
      if nops(args()) = 0 then
        dom::create("applyvoid", "", "", dom(op(args(), 0)));
      else
        arg1 := op(map([op(args())], dom));
        if testtype(op(args(), 0), "_fnest") and
           contains({D, hold(D)}, op(args(), [0,1])) then
          // replace (D@@n)(f) by f', f'', f''' or f^(n)
          if op(args(), [0,2]) = 1 then
            dom::create("D", "", "", arg1)
          elif op(args(), [0,2]) = 2 then
            dom::create("D2", "", "", arg1)
          elif op(args(), [0,2]) = 3 then
            dom::create("D3", "", "", arg1)
          else
            dom::create("DN", "", "", arg1, dom(op(args(), [0,2])))
          end_if
        else
          dom::create("apply", "", "", dom(op(args(), 0)), arg1);
        end_if
      end_if;
    end_proc;
    
    /** Tables for translations from MML-constants to MuPAD constants
        and vice versa.  */ 
    MML2ident := table();
    
    /** Table for translations from MML-constants to MuPAD constants. */ 
    ident2MML := table();
    
    
    /** fills the tables MML2ident and ident2MML in the init section */ 
    translateIdents :=
    proc(equation) //  : Type::Equation(DOM_IDENT) falsch!!
    begin
      dom::MML2ident[op(equation, 1)] := op(equation, 2);
    dom::ident2MML[op(equation, 2)] := op(equation, 1);
  end_proc;

end_category:
  
// end of file 
