/*    */
/* tonner, 23/06/98 */

/** output::CatUtils -- Utilies for the output generation
 */


/**  Utilies for the output generation
 *
 *   This domain provides utilities for Content based outputs.
 */
category output::CatUtils
  
/** Name : DOM_STRING
 *
 *  Every domain derived from output::CatUtils has to provide a Name
 *  entry which is used as slot name to store output methods for this
 *  output type.  E.g. if a domain output::MMLcontent derived from
 *  output::CatContent has the Name entry "MMLContent" the output 
 *  method for lists for the output type output::MMLcontent is stored
 *  and searched for in DOM_LIST::MMLContent.
 */
  Name;
  
/** outputType : DOM_STRING
 *
 *  outputType may be one of the strings "Content" or "Presentation"
 *  and defines which kind of output should be generated.
 */
  outputType;
  

/** create and print
 *
 *  These methods define how to create the internal representation
 *  and how to print it on the screen 
 */
  create;  print;
  
  expr2text := o -> expr2text(subsop(#dom(extop(o)),
                                     0=hold(slot)(dom, "create"),
                                     Unsimplified));
  
/** setAliasTab
 *
 *  set a table for alias replacements
 */
  setAliasTab := x -> sysassign(dom::aliasTab, x);
  aliasTab := table();

  currentObject := FAIL;
/** Method new - converts MuPAD data into its output representation
  *
  * hier ist das Auffinden von Methoden implementiert.  
  * Sollte in den Kern !!!!
  */
  new :=
  proc()
    local argType, method, result, Args, unknownType;
    save _domainOutputMode;
  begin
    // used for elements of domains without output methods
    unknownType := () -> dom::stdFunc(hold(new)((args())::dom, extop(args())));
    
    Args := [args()];

    // look for alias replacements
    if contains(dom::aliasTab, op(Args)) then
      return(dom(dom::aliasTab[op(Args)]));
    elif testtype(op(Args), DOM_COMPLEX) and contains(dom::aliasTab, I) then
      return(dom(subs(op(Args), op(dom::aliasTab))));
    end_if;
    
    // do not assign args() directly to a local variable.  If
    // args() is an unnamed procedure, it will receive the name
    // of the local variable as a side effect !!!
    argType := (op(Args))::dom;

    if (method := slot(argType, dom::Name)) <> FAIL then
      /*
       * a special output function is defined; use it
       */
      result := method(dom, op(Args));
    elif (method := slot(argType, dom::outputType)) <> FAIL then
      /*
       * 
       */

      /* avoid assignment below; generate::MathML(matrix([[1 ,2], [3, 4]]))
         crashes  */
//      eval(hold(sysassign)( hold(slot)(text2expr(expr2text(argType)),
//                                       dom::Name), method));
      result := method(dom, op(Args));
    elif (method := argType::print) <> FAIL then
      /*
       *  und nun alte "print"-Methode Aufrufen und deren Ergebnis ausgeben  
       */
      Args := [method(op(Args))];
      _domainOutputMode := TRUE;
      result := dom(op(Args));
      if result::dom = DOM_STRING then
        if stringlib::contains(result, "^") or
           stringlib::contains(result, "_") then
          error("no typesetting for print-strings with ^ or _");
        else
          /* we want to see the output unquoted */
          result := hold(``).result;
        end_if;
      end_if;
    else
      result := unknownType(op(Args));
    end_if;
    
    return(result)
  end_proc;
  
  testtype := FALSE;

  stdFunc;  // Domains of this type have to define a method 
            // stdFunc for the output of generic functions

  statement;  // defines the output of statements

  // called once per output -- e.g.  set LaTeX output in \[ ... \] 
  enclose := id;


 //++++++++++++++++ a collection of utility routines  ++++++++++++++

  // decide whether x is an operator
  isOperator :=
  proc(x)
  begin
    if x::dom = DOM_IDENT then
      x := eval(x);
    end_if;
    if x::dom = DOM_FUNC_ENV then
      if testtype(op(x,[2,3]), DOM_STRING) then
        TRUE else FALSE
      end_if;
    else
      FALSE
    end_if;
  end_proc;
  // decide whether x is an infix operator
  isInfixOperator :=
  proc(x)
  begin
    if x::dom = DOM_IDENT then
      x := eval(x);
    end_if;
    if x::dom = DOM_FUNC_ENV then
      if testtype(op(x,[2,3]), DOM_STRING)
        and (op(x, [2,1]) = 1100 or op(x, [2,1]) = 1097) then
        TRUE else FALSE
      end_if;
    else
      FALSE
    end_if;
  end_proc;
//++++++++++++++++ a collection of utility routines  ++++++++++++++
 
end_category:

// end of file 
