//    
// tonner, 23/06/98 

/*++
output::ContentLayout -- Domain of MathML presentation outputs
++*/


domain ContentLayout
  category output::CatUtils;  // implements new
  inherits Dom::BaseDomain;
    
  Name := "ContentLayout";
  outputType := "ContentLayout";
  statement := error;
  stdFunc := error;
    
  create :=
  proc(mlType : DOM_STRING)
    local argList;
  begin
    argList := split([args(2..args(0))], x -> testtype(x, "_equal"));
    new(dom, mlType, [op(op(argList,1))],
        op(op(argList,2)))
  end_proc;

  // access to element entries
  layoutType := elem -> extop(elem, 1);
  attributes := elem -> extop(elem, 2);
  entries    := elem -> op(elem, 3..extnops(elem));

    
  OutputFile := 0;

  print := arg1 ->
           if dom::layoutType(arg1) = "content" then
             hold(ContentLayout::content)(hold(id)=
                                          op(dom::attributes(arg1), [1, 2]))
           else
             hold(slot)(ContentLayout, dom::layoutType(arg1))()
           end;
  
  /* output in XML notation */
  xml := proc(arg1) begin dom::do_print(arg1) end_proc;

  do_print :=
  proc(arg1)
    local DOM, process, Print;
  begin
    DOM := dom;
    
// extract args
  Print :=
  proc(d)
    local attributes, i, Indent, Empty, entries;
  begin
    Indent := {"mrow", "layout", "content", "msup", "msub",
               "munder", "move", "munderover", "mroot", "msqrt",
               "optable", "oplists", "oprow", "mathsetup" };
    Empty := {"oper"};
    attributes := DOM::attributes(d);
    entries := DOM::entries(d);
    "<", DOM::layoutType(d),
    (if attributes <> [] then
       (" ", op(attributes, [i,1]), "=",
	expr2text(op(attributes, [i,2]))) $ i=1..nops(attributes)
     else
       null()
     end_if),
    (if contains(Empty, DOM::layoutType(d)) or entries = null() then "/>"
     else
       ">",
       (if contains(Indent, DOM::layoutType(d)) then
	  DOM::newline(), DOM::indent(entries)
        elif entries::dom = DOM_STRING then
          DOM::translate(entries)
        else
          entries
        end_if),
     "</", DOM::layoutType(d),">"
     end_if),
    DOM::newline()
  end_proc;

    process :=
    proc(x)
      local Oseq, i, entries;
    begin
      Oseq := [Print(x)];
      for i in Oseq do
	if i::dom = DOM_STRING then
     fprint(NoNL, DOM::OutputFile, i);
	elif i::dom = output::Indent then
	  if output::Indent::isNewline(i) then
	    fprint(NoNL, DOM::OutputFile, "\n");
	  else
	 //   indentLevel := indentLevel+1;
    //   fprint(NoNL, DOM::OutputFile, "  ");
	    if (entries := output::Indent::entries(i)) <> null() then
	      map(entries,process);
	    end_if;
	 //   indentLevel := indentLevel-1;
	  end_if;
	elif i::dom = DOM then
	  process(i);  
	else
// print("process", i, i::dom, DOM);
	  error("output element expected");
	end_if;
      end_for;
    end_proc;

    process(dom::enclose(arg1));
    null();
  end_proc;

  translate := str -> _concat(op(subs(text2list(str, ["&"]), "&"="&amp;")));
//  translate := str -> stringlib::subs(str, "&"="&amp;");

  // optable, oplists or oprow?
  hasOptable :=
    proc(o)
      option remember;
      local kids, i;
    begin
      if dom::layoutType(o) = "optable" or
         dom::layoutType(o) = "oplists" then
	TRUE
      else
	kids := [dom::entries(o)];
	for i in kids do
	  if dom::hasOptable(i) = TRUE then
	    return(TRUE);
	  end_if;
	end_for;
	FALSE;
      end_if;
    end_proc;
    
  mi :=
  () -> dom::create("mi",     args());
    
  mn            := () -> dom::create("mn",     args());
  mo            := () -> dom::create("mo",     args());
  mtext         := () -> dom::create("mtext",  args());
  ms            := () -> dom::create("ms",     args());
  
  mrow          := () -> dom::create("mrow",  args());
  mfrac         := () -> dom::create("mfrac", args());

  msub          := () -> dom::create("msub", args());
  msup          := () -> dom::create("msup", args());
  munder        := () -> dom::create("munder", args());
  mover         := () -> dom::create("mover", args());
  munderover    := () -> dom::create("munderover", args());
  
  mroot         := () -> dom::create("mroot",  args());
  msqrt         := () -> dom::create("msqrt",  args());
    
  oplists       := () -> dom::create("oplists", args());
  optable       := () -> dom::create("optable", args());
  oprow         := () -> dom::create("oprow", args());
  oper          := proc()
                     local tab, s, Args;
                   begin
                     s := split([args()], testtype, "_equal");
                     tab := table(op(op(s,1)));
                     if contains(tab, "prio") and
                       not testtype(tab["prio"], DOM_STRING) then
                       tab["prio"] := expr2text(tab["prio"]);
                     end_if;
                     Args := op(s, 2);
                     dom::create("oper", op(tab), op(Args));
                   end_proc;
    
  arities := table("plus"="1*",
                   "sep"="0",
                   "condition"="1*");
  mathsetup     := () -> dom::create("mathsetup", args());
  content       := proc()
                     local tab, s, Args;
                   begin
                     s := split([args()], testtype, "_equal");
                     tab := table(op(op(s,1)));
                     if contains(tab, "arity") and contains(tab, "id") then
                       sysassign(dom::arities[tab["id"]], tab["arity"]);
                     else
                       warning("arity or id missing in output template")
                     end_if;
                     if contains(tab, "prio") and
                       not testtype(tab["prio"], DOM_STRING) then
                       tab["prio"] := expr2text(tab["prio"]);
                     end_if;
                     Args := op(s, 2);
                     dom::create("content", op(tab), op(Args));
                   end_proc;
  layout        := () -> dom::create("layout", args());



  // formatting of source output
  newline := proc() option remember; begin output::Indent("newline") end_proc;
  indent :=  () -> output::Indent("indent", args());
    
end_domain:
  
// end of file 
