DOM_EXPR::Content := 
proc(Out:DOM_DOMAIN)
  local arg1, op0, arg0, method, i, printRes;
begin
  arg1 := args(2..args(0));
  // replace identifier Out == Ou.t by current value of formal parameter Out
  op0 := subs(op(arg1, 0), hold(Ou).hold(t)=Out);

  // look for alias replacements of the 0th operand
  if contains(Out::aliasTab, op0) then
    return(Out::new(subsop(arg1, 0=Out::aliasTab[op0], Unsimplified)))
  end_if;
    
  // again because of accees via % below
  op0 := subs(op(arg1, 0), hold(Ou).hold(t)=Out);
  if domtype(op0)=DOM_IDENT or type(op0) = "slot" then
    arg0 := eval(%);
  else
    arg0 := op0;
    op0 := text2expr(expr2text(op0));
  end_if;
  
  if domtype(arg0) = DOM_FUNC_ENV then
    if (method := slot(arg0, Out::Name)) <> FAIL then
      method(Out, arg1);
    elif (method := arg0::Content) <> FAIL then
      // don't worry if the assignment fails, just ignore the error
      traperror(context(subsop(hold(sysassign(NIL, NIL)),
                               1=op0,
                               2=slot(arg0, Out::Name, method), Unsimplified)));
      method(Out, arg1);
    elif
      op(arg0, 2) <> NIL then
      if domtype(op(arg0, 2)) <> DOM_EXEC then
        printRes := op(arg0, 2)(arg1);
        if printRes <> FAIL then
          if domtype(printRes) = DOM_STRING then
            return(Out(hold(``).printRes))
          else
            return(Out(printRes))
          end_if
        end_if
      end_if;
      if Out::isOperator(arg0) then
        if Out::isInfixOperator(arg0) then
          // arg0 is an infix operator; use its operator string
          Out::Capply(Out::Crow,  Out(op(arg1, 1)),
                      (hold(``).stringlib::subs(op(arg0, [2,3]),
                                                " "="&blank;"),
                       Out(op(arg1, i))) $
                      i = 2..nops(arg1))
        elif Out::isPostfixOperator(arg0) then
          // arg0 is an operator; use its operator string
          Out::Capply(Out::Crow,  Out(op(arg1, 1)),hold(``).op(arg0, [2,3]))
        elif Out::isPrefixOperator(arg0) then
          // arg0 is an operator; use its operator string
          Out::Capply(Out::Crow,  hold(``).op(arg0, [2,3]), Out(op(arg1, 1)))
        else
          // Ooops, are there any other operators?
          error("unknown operator type")
        end_if;
        // this special case breaks max(x,y)
 //     elif op(arg0, [2, 1]) = 1101 then  // system function
 //       Out(subsop(hold(dummy)(op(arg1)), 0=hold(``).op(arg0, [2, 4])))
      else  // DOM_EXEC but no operator or system function
        Out::stdFunc(arg1)
      end;
    else
	// functional output
      Out::stdFunc(arg1)
    end_if;
  else
    // functional output
    Out::stdFunc(arg1)
  end_if;
end_proc:

//++++++++++++++++ default output of statements   +++++++++++++++++
/* _assign::Content   := Content::statement: defined in sysinit.mu */
/* sysassign::Content := Content::statement: dito*/
_break::Content    := Content::statement:
_case::Content     := Content::statement:
_for::Content      := Content::statement:
_for_down::Content := Content::statement:
_for_in::Content   := Content::statement:
_if::Content       := Content::statement:
_next::Content     := Content::statement:
_quit::Content     := Content::statement:
_repeat::Content   := Content::statement:
_stmtseq::Content  := Content::statement:
_while::Content    := Content::statement:
//++++++++++++++++ default output of statements   +++++++++++++++++
