    //------------------------------------------------------------
    //                                   b                        
    //                         a^b  ->  a                         
    //------------------------------------------------------------
_power::Content := 
proc(Out, data) 
  local root, Exponent, exponent, base, factors, Sign, res;
begin
  if nops(data) <> 2 then
    return(Out::stdFunc(data));
  end_if;
  /* first we split the power into base^(Sign*(exponent/root)) */
  base := op(data, 1);
  root := 1;
  Exponent := op(data, 2);
  Sign := 1;

  if domtype(Exponent) = DOM_RAT then
    if Exponent < 0 then
      Sign := -1;
      exponent := -op(Exponent, 1);
      root := op(Exponent, 2);
    else
      root := op(Exponent, 2);
      exponent := op(Exponent, 1);
    end_if;
  elif type(Exponent) = "_mult" then
    factors := generate::splitProduct(Exponent);
    if op(factors, 1) = -1 then
      Sign := -1
    end_if;
    if nops(op(factors, 2)) = 1 then
      exponent := op(op(factors, 2));
    else
      exponent := hold(_mult)(op(op(factors, 2)));
    end_if;
    if nops(op(factors, 3)) = 0 then
      root := 1;
    elif nops(op(factors, 3)) = 1 then
      root := op(op(factors, 3));
    else
      root := hold(_mult)(op(op(factors, 3)));
    end_if;
  elif type(Exponent) = "_power" then
    if op(Exponent, 2) = -1 then
      root := op(Exponent, 1);
      exponent := 1;
    else
      root := 1;
      exponent := Exponent;
    end_if;
  elif type(Exponent) = "_divide" then
    exponent := op(Exponent, 1);
    if generate::isNeg(exponent) then
      Sign := -1;
      exponent := -exponent;
    end:
    root := op(Exponent, 2);
  elif type(Exponent) = "_invert" then
    root := op(Exponent);
    exponent := 1;
  elif type(Exponent) = "_negate" then
    root := 1;
    exponent := op(Exponent);
    Sign := -1;
  elif type(Exponent) = "_plus" and generate::isNeg(Exponent) then
    root := 1;
    exponent := -Exponent;
    Sign := -1;
  elif type(Exponent) = DOM_INT and Exponent < 0 and
    not testtype(base, Type::Real) and not type(base)="matrix"
    and not base::dom::hasProp(Cat::Matrix) = TRUE then
    root := 1;
    exponent := -Exponent;
    Sign := -1;
  else
    root := 1;   
    exponent := Exponent; 
  end_if;

  if exponent = 1 and contains({1,2}, root) then
    if root = 1 then
      res := Out(base):
    else  // root = 2
      res := Out::Capply(Out::Croot, Out(base));
    end_if;
  else
    if root <> 1 then
      // output with fractional exponent
      if Out = Content and
         map({exponent, root}, domtype) minus {DOM_INT, DOM_IDENT, DOM_FLOAT, DOM_COMPLEX} = {}  and
         (domtype(exponent) <> DOM_COMPLEX or exponent = I) and
         (domtype(exponent) <> DOM_COMPLEX or exponent = I) then
        exponent := Out::create("divideLinear", "", "", Out(exponent), Out(root));
      else
        exponent := Out(hold(_divide)(exponent, root));
      end_if;
      res := Out::Capply(Out::Cpower, Out(base), exponent):
    elif exponent <> 1 then
      base := Out(base);
      exponent := Out(exponent);
      res := Out::Capply(Out::Cpower, base, exponent):
    else
      res := Out(base):
    end_if;
  end_if;

  if Sign = -1 then
    Out::Capply(Out::Cdivide, Out(1), res)
  else
    res
  end_if;
end_proc:
