domain output::MMLContent
  category output::CatContent;
    inherits Dom::BaseDomain;
    
    Name := "MMLContent";

    // Counter for IDs of subexpressions
    refCount := 0;
    
    // MMLContent has no elements, no print needed
    // slot added to make prog::check happy
    print := "output::MMLContent has no elements";
    
// no own representation!
// elements of adt::XML are created    
    create := proc(ID, arg2)
                local nextRef;
              begin
                if not contains({"math", "semantics", "annotation",
                                 "annotation-xml", "bvar", "degree",
                                 "lowlimit", "uplimit", "condition"}, ID) and
                  args(0) > 1 and args(args(0)) <> DOM_SET then
                  dom::refCount := dom::refCount+1;
                  nextRef := "id"="No".dom::refCount;
                else
                  nextRef := null();
                end_if;

                // make sure that the id is always the 1st attribute
                if args(0) > 1 and domtype(arg2) = DOM_LIST then
                  adt::XML::Element(ID,
                      [nextRef, op(args(2))],
                      args(3..args(0)))
                else
                  adt::XML::Element(ID, [nextRef], args(2..args(0)))
                end_if;
              end_proc;
    
    /// ConTeXt has some bugs/expects old syntax/...
    /// This switch enables MuPAD to write MathML suitable for ConTeXt.
    fixesForConTeXt := proc()
                       option escape;
                       local value;
                     begin
                       value := FALSE;  // initial setting
                       proc(x)
                         local oldVal;
                       begin
                         if args(0) = 1 then
                           if contains({TRUE, FALSE}, x) then
                             oldVal := value;
                             value := x;
                             oldVal
                           else
                             error("TRUE or FALSE expected")
                           end_if;
                         else
                           // return value
                           value
                         end_if;
                       end_proc;
                     end_proc();
    
    // print a standard function f(a,b)
    stdFunc := () -> if dom::fixesForConTeXt() = TRUE then
                       dom::create("apply",
                                   dom::create("fn", dom(op(args(), 0))),
                                   op(map([op(args())], dom)));
                     else
                       dom::create("apply", dom(op(args(), 0)),
                                 op(map([op(args())], dom)));
                     end_if;

    XML_accents := table("OverBar"  = ["mover",  ["accent"="true"], "&OverBar;"],
                         "UnderBar" = ["munder", ["underaccent"="true"], "&UnderBar;"],
                         "ast"      = ["msup",   [], "*"],
                         "prime"    = ["msup",   [], "&prime;"],
                         "circ"     = ["mover",  ["accent"="true"], "&Hat;"],
                         "tilde"    = ["mover",  ["accent"="true"], "&Tilde;"],
                         "rarr"     = ["mover",  ["accent"="true"], "&RightArrow;"],
                         "dot"      = ["mover",  ["accent"="true"], "."],
                         "Dot"      = ["mover",  ["accent"="true"], "&DoubleDot;"],
                         "ddot"     = ["mover",  ["accent"="true"], "&DoubleDot;"],
                         "die"      = ["mover",  ["accent"="true"], "&DoubleDot;"],
                         "tdot"     = ["mover",  ["accent"="true"], "&TripleDot;"]);

    // take apart an identifier potentially containing _ or accents
    analyzeIdent :=
    proc(s : DOM_STRING)
      local t;
    begin
      if length(s)>1 and s[1]="`" and s[-1]="`" then
        s := s[2..-2];
      end_if;
      if s = "" then return(dom::create("mi", s)); end_if;
            if s <> "" and s[-1]=";" and
         ((t := strmatch(s, ".+&", Index))) <> FALSE and
         contains(dom::XML_accents, s[t[2]+1..-2])
      then
        [s, t] := [s[1..t[2]-1], s[t[2]+1..-2]];
        t := dom::XML_accents[t];
        dom::create(t[1], t[2], dom::analyzeIdent(s),
          dom::create("mo", t[3]));
      elif ((t := strmatch(s, "._", Index))) <> FALSE then
        dom::create("msub", dom::analyzeIdent(s[1..t[2]-1]), dom::analyzeIdent(s[t[2]+1..-1]));
      else
        dom::create("mi",
          [if length(s)>1 and s[1] <> "&"
           then "mathvariant"="normal" else null() end_if],
          s);
      end_if;
    end_proc;
    
    /* math wrapper */
//   Cmath:= () -> dom::create("math", args());
    
    
    
    /*
     * token elements
     */
    Ccn:= () -> dom::create("cn", args());

    Cci:=
    proc(x)
      local str;
    begin
      if contains(dom::ident2MML, args()) then
        if testtype(dom::ident2MML[args()], DOM_IDENT) then
          dom::create("ci", dom::analyzeIdent(expr2text(dom::ident2MML[args()])))
        else
          dom::ident2MML[args()];
        end_if
      else
        str := expr2text(args());
        dom::create("ci", if length(str) = 1  then
                            str   // a-z, _ or #
                          else
                            dom::analyzeIdent(str);      // Content Identifier
                          end_if);
      end_if
    end_proc;
    Ccsymbol := () -> dom::create("csymbol", args());
    
    
    /*
     * basic content elements
     */
    Capply   := () -> dom::create("apply", op(select([args()], testtype, adt::XML)));

    // OBSOLETE
    Creln      := () -> dom::create("reln", args());
    Cfn        := () -> dom::create("fn", args());   // user-defined function
    
    Cinterval  := () -> dom::create("interval", args());
    Cinverse   := dom::create("inverse");
    Csep       := () -> dom::create("sep", args());     // separator
    Ccondition := () -> dom::create("condition", args());
    Cdeclare   := () -> dom::create("declare", args());
    Clambda    := () -> dom::create("lambda", args());
    Ccompose   := dom::create("compose", args()); // composition operator
    Cident     := dom::create("ident", args());   // identity function
    Cdomain    := dom::create("domain", args());
    Ccodomain  := dom::create("codomain", args());
    Cimage     := dom::create("image", args());
    Cdomainofapplication := () -> dom::create("domainofapplication", args());
    Cpiecewise := () -> dom::create("piecewise",  args());
    Cpiece     := () -> dom::create("piece",  args());
    Cotherwise := () -> dom::create("otherwise", args());

    
    
    // Arithmetic, Algebra and Logic
    Cquotient  := dom::create("quotient");
    Cfactorial := dom::create("factorial");
    Cdivide    := dom::create("divide");
    Cmax       := dom::create("max");
    Cmin       := dom::create("min");
    Cminus     := dom::create("minus");
    Cplus      := dom::create("plus");
    Cpower     := dom::create("power");
    Crem       := dom::create("rem");
    Ctimes     := dom::create("times");
    Croot      := dom::create("root");
    Cgcd       := dom::create("gcd");
    Cand       := dom::create("and");
    Cor        := dom::create("or");
    Cxor       := dom::create("xor");
    Cnot       := dom::create("not");
    Cimplies   := dom::create("implies");
    Cforall    := dom::create("forall");
    Cexists    := dom::create("exists");
    Cabs       := dom::create("abs");
    Cconjugate := dom::create("conjugate");
    Carg       := dom::create("arg");
    Creal      := dom::create("real");
    Cimaginary := dom::create("imaginary");
    Clcm       := dom::create("lcm");
    Cfloor     := dom::create("floor");
    Cceiling   := dom::create("ceiling");
    
   // Relations
    Ceq         := dom::create("eq");
    Cneq        := dom::create("neq");
    Cgt         := dom::create("gt");
    Clt         := dom::create("lt");
    Cgeq        := dom::create("geq");
    Cleq        := dom::create("leq");
    Cequivalent := dom::create("equivalent");
    Capprox     := dom::create("approx");
    Cfactorof   := dom::create("factorof");
    
   // Calculus
    Cint         := dom::create("int");
    Cdiff        := dom::create("diff");  
    Cpartialdiff := dom::create("partialdiff");
    Clowlimit    := () -> dom::create("lowlimit", args());
    Cuplimit     := () -> dom::create("uplimit", args());
    Cbvar        := () -> dom::create("bvar", args());
    Cdegree      := () -> dom::create("degree", args());
    Cdivergence  := dom::create("divergence");
    Cgrad        := dom::create("grad");
    Ccurl        := dom::create("curl");
    Claplacian   := dom::create("laplacian");
    
   // Theory of sets
    Cset  := () -> if args(0) = 0 then
                     dom::Cemptyset()
                   else 
                     dom::create("set", args())
                   end_if;
    Clist             := () -> dom::create("list", args());
    Cunion            := dom::create("union");
    Cintersect        := dom::create("intersect");
    Cin               := dom::create("in"); 
    Cnotin            := dom::create("notin");
    Csubset           := dom::create("subset");
    Cprsubset         := dom::create("prsubset");
    Cnotsubset        := dom::create("notsubset");
    Cnotprsubset      := dom::create("notprsubset");
    Csetdiff          := dom::create("setdiff");
    Ccard             := dom::create("card");
    Ccartesianproduct := dom::create("cartesianproduct");
    
   // Sequences and Series
    Csum     := dom::create("sum");
    Cproduct := dom::create("product");
    Climit   := dom::create("limit");
    Ctendsto := () -> dom::create("tendsto", args());
    
    
    /*
     * elementary classical functions
     */
    Cexp     := dom::create("exp");   
    Cln      := dom::create("ln");
    Clog     := dom::create("log");
    Csin     := dom::create("sin");
    Ccos     := dom::create("cos");
    Ctan     := dom::create("tan");
    Csec     := dom::create("sec");
    Ccsc     := dom::create("csc");
    Ccot     := dom::create("cot");
    Csinh    := dom::create("sinh");
    Ccosh    := dom::create("cosh");
    Ctanh    := dom::create("tanh");
    Csech    := dom::create("sech");
    Ccsch    := dom::create("csch");
    Ccoth    := dom::create("coth");
    Carcsin  := dom::create("arcsin");
    Carccos  := dom::create("arccos");  
    Carctan  := dom::create("arctan");
    Carcsec  := dom::create("arcsec");
    Carccsc  := dom::create("arccsc");
    Carccot  := dom::create("arccot");  
    Carcsinh := dom::create("arcsinh");  
    Carccosh := dom::create("arccosh");
    Carctanh := dom::create("arctanh");
    Carcsech := dom::create("arcsech");
    Carccsch := dom::create("arccsch");  
    Carccoth := dom::create("arccoth");
    
   // Statistics
    Cmean          := dom::create("mean");
    Csdev          := dom::create("sdev");
    Cvariance      := dom::create("variance");
    Cmedian        := dom::create("median");
    Cmode          := dom::create("mode");
    Cmoment        := dom::create("moment");
    Cmomentabout   := () -> dom::create("momentabout", args());
    
   // Linear Algebra
   // 1. argument might be a set containing attributes
    Cvector        := () -> dom::create("vector", op(select([args()], testtype,
                                                            adt::XML)));
   // 1. argument might be a set containing the constructor
    Cmatrix        := () -> dom::create("matrix", op(select([args()], testtype,
                                                            adt::XML)));
    Cmatrixrow     := () -> dom::create("matrixrow", args());
    Cdeterminant   := dom::create("determinant");  
    Ctranspose     := dom::create("transpose");
    Cselector      := dom::create("selector");
    Cscalarproduct := dom::create("scalarproduct"); 
    Cvectorproduct := dom::create("vectorproduct"); 
    Couterproduct  := dom::create("outerproduct");
    
   // Semantic Mapping Elements
    Cannotation    := () -> dom::create("annotation", args()); 
    Csemantics     := () -> dom::create("semantics", args());
    // MathML name is no valid MuPAD identifier
    CannotationXml := () -> dom::create("annotation-xml", args());
    
   // Constants
    Cintegers       := dom::create("integers");
    Creals          := dom::create("reals");
    Crationals      := dom::create("rationals");
    Cnaturalnumbers := dom::create("naturalnumbers");
    Ccomplexes      := dom::create("complexes");
    Cprimes         := dom::create("primes");
    Cexponentiale   := dom::create("exponentiale");
    Cimaginaryi     := dom::create("imaginaryi");
    Cnotanumber     := dom::create("notanumber");
    Ctrue           := dom::create("true");
    Cfalse          := dom::create("false");
    Cemptyset       := dom::create("emptyset");
    Cpi             := dom::create("pi");
    Ceulergamma     := dom::create("eulergamma");
    Cinfinity       := dom::create("infinity");
    
   // MuPAD extensions
    Cabbreviation   := () -> ("not yet implemented");
    Cassign         := dom::create("assign");
    CbesselI        := dom::create("besselI");
    CbesselJ        := dom::create("besselJ");
    CbesselK        := dom::create("besselK");
    CbesselY        := dom::create("besselY");
    Cbeta           := dom::create("beta");
    Cbinomial       := dom::create("binomial"); 
    Ccomprow        := dom::create("comprow");        // needed for doc
    Cconcat         := dom::create("concat");
    Cdilog          := dom::create("dilog");
    Cdirac          := dom::create("dirac");
    CellipticCE     := dom::create("ellipticCE");
    CellipticCK     := dom::create("ellipticCK");
    CellipticCPi    := dom::create("ellipticCPi");
    CellipticE      := dom::create("ellipticE");
    CellipticF      := dom::create("ellipticF");
    CellipticK      := dom::create("ellipticK");
    CellipticNome   := dom::create("ellipticNome");
    CellipticPi     := dom::create("ellipticPi");
    // we use the MathML notation here
    Cequiv          := dom::create("equivalent");
    CequivMod       := dom::create("equivalent");     // needed for doc
    CevalAt         := dom::create("evalAt");
    // equation system;  will be translated into a set of equations
    CEQS            := () -> dom::create("EQS", args());
    CEQS3           := () -> dom::create("EQS3", args());
    Cexprseq        := dom::create("exprseq");
    Cfactorial2     := dom::create("factorial2");
    Cfenced         := dom::create("fenced");         // needed for doc
    Cfnest          := dom::create("fnest");
    CfresnelC       := dom::create("fresnelC");
    CfresnelS       := dom::create("fresnelS");
    CfuncDecl       := dom::create("funcDecl");       // needed for doc
    Cgamma          := dom::create("gamma");
    Chtranspose     := dom::create("htranspose");
    Chypergeom      := dom::create("hypergeom");
    Cigamma         := dom::create("igamma");
    Cindex          := dom::create("index");
    CinverseMatrix  := dom::create("inverseMatrix");
    CintPV          := dom::create("int");            // output as usual int
    CjacobiAM       := dom::create("jacobiAM");
    CjacobiCD       := dom::create("jacobiCD");
    CjacobiCN       := dom::create("jacobiCN");
    CjacobiCS       := dom::create("jacobiCS");
    CjacobiDC       := dom::create("jacobiDC");
    CjacobiDN       := dom::create("jacobiDN");
    CjacobiDS       := dom::create("jacobiDS");
    CjacobiNC       := dom::create("jacobiNC");
    CjacobiND       := dom::create("jacobiND");
    CjacobiNS       := dom::create("jacobiNS");
    CjacobiSC       := dom::create("jacobiSC");
    CjacobiSD       := dom::create("jacobiSD");
    CjacobiSN       := dom::create("jacobiSN");
    CjacobiZeta     := dom::create("jacobiZeta");
    CkroneckerDelta := dom::create("kroneckerDelta");
    ClambertW       := dom::create("lambertW");
    Clngamma        := dom::create("lngamma");
    CmeijerG        := dom::create("meijerG");
    Cnorm := () -> if args(0) = 1 then
                     dom::create("infinitynorm", args());
                   elif args(2) = hold(Infinity) then
                     dom::create("infinitynorm", args(1));
                   elif args(2) = 1 then
                     dom::create("onenorm", args(1));
                   elif args(2) = hold(Frobenius) then
                     dom::create("norm", args(1));
                   else
                     dom::create("othernorm", args());
                   end_if;
    Cpochhammer     := dom::create("pochhammer");
    Cpolylog        := dom::create("polylog");
    Cpsi            := dom::create("psi");
    CquadraticMean  := dom::create("quadraticMean");
    Crange          := dom::create("range"); 
    Crow            := dom::create("row");
    Cseqgen         := dom::create("seqgen");
    Cseqstep        := dom::create("seqstep");
    Cseqin          := dom::create("seqin");
    Cslot           := dom::create("slot");
    Ctable          := () -> dom::create("table", args());
    Ctableau        := () -> dom::create("tableau", args());
    Cunknown        := dom::create("unknown");
    CUnion          := dom::create("Union");
    Cunit           := dom::create("unit");
    CwhittakerM     := dom::create("whittakerM");
    CwhittakerW     := dom::create("whittakerW");
    CwrightOmega    := dom::create("wrightOmega");
    Czeta           := dom::create("zeta");
    

  end_domain:

// initialize identifier translation tables
map([  hold(`NIL`) = NIL, hold(`FAIL`) = FAIL, 
       hold(``) = null(), hold(`NULL`) = null(),
       hold(`TRUE`) = TRUE, hold(`FALSE`) = FALSE,
       hold(`UNKNOWN`) = UNKNOWN,
       `&pi;` = PI, output::MMLContent::Cpi() = PI,
       output::MMLContent::Cinfinity() = hold(infinity),
       output::MMLContent::Ceulergamma() = EULER,  
       output::MMLContent::Cintegers() = hold(Z_),
       output::MMLContent::Crationals() = hold(Q_),  
       output::MMLContent::Creals() = hold(R_),
       output::MMLContent::Ccomplexes() = hold(C_), 
       output::MMLContent::Cnaturalnumbers() = hold(N_),
       output::MMLContent::Cprimes() = hold(P_)], 
     output::MMLContent::translateIdents):


alias(MathML=output::MMLContent):
MathML::set("ci", FAIL, bla, x-> op(x)):  /* ! keine Simplifizierung */
MathML::set("subtract", FAIL, _subtract):  /* ! keine Simplifizierung */
MathML::set("apply", FAIL, error,
            x -> MathML::expr(op(x, 1))(map(extop(x, 3..nops(x)), MathML::expr))):
MathML::set("plus", FAIL, _plus):  /* ! keine Simplifizierung */
