/*
 * output::asciiAbbreviate:  generator of a ASCII output function
 *                           with uses abbreviations.
 * Arguments:  varname : the basename of the abbreviation replacement
 *                       identifier
 * Return value:  a procedure which generates an ASCII output of its
 *                arguments with abbreviations.
 */


output::asciiAbbreviate :=
proc(varname = # : DOM_IDENT)
  option escape;
  save TEXTWIDTH;
begin
  proc()
    local res, str, i;
  begin
    if not PRETTYPRINT then
      return(args())
    end_if;
    res := output::subexpr([args()], varname);
    traperror((TEXTWIDTH := TEXTWIDTH-2));
    str := strprint(op(res[1]));
    if nops(res) > 1 then
      str := str."\nwhere\n".
           ("\n   ".stringlib::subs(strprint(res[i]),
                                      "\n"="\n   ", "\b"="\n   ") $
            i = 2..nops(res))
    end_if;
    if str[-1] = "\n" or str[-1] = "\b" then
      str := str[1..-2];
      if str[-1] = "\r" then
        str := str[1..-2];
      end_if;
    end;
    stdlib::Exposed(str);
  end_proc
end_proc:
