/*
 *   output::mathText:  domain for the output of mixed text an mathematical
 *                      formulars.
 */
output::mathText := newDomain(hold(output::mathText)):

output::mathText::info :=
"domain for the output of mixed text an mathematical formulars":

output::mathText::new := () -> new(dom, op(select([args()], _unequal, ""))):

output::mathText::print :=
e -> if extnops(e) = 1 then
       id
     else
       _outputSequence
     end(map(extop(e), x -> if testtype(x, DOM_STRING) then
                              stdlib::Exposed(x)
                            else
                              x
                            end, Unsimplified)):

output::mathText::expr2text := e -> "output::mathText(".expr2text(extop(e)).")":

output::mathText::Content :=
(Out, e) -> Out(if extnops(e) = 1 then
                  id
                else
                  _outputSequence
                end(map(extop(e),
                        x -> if testtype(x, DOM_STRING) then
                               hold(``).stringlib::subs(x, " "="&blank;")
                             else
                               x
                             end, Unsimplified))):

output::mathText::TeX :=
e -> _concat(map(extop(e), x -> if testtype(x, DOM_STRING) then
                                  "\\text{".x."}"
                                else
                                  generate::TeX(x)
                                end
                 )):

output::mathText::MuPlotML :=
proc(e)
begin
  if testtype(extop(e), DOM_STRING) then
    xmlprint::data(plot::MuPlotML::OutputFile, extop(e));
  else
    xmlprint::beginElement(plot::MuPlotML::OutputFile, "math",
                           "alt"=expr2text(output::mathText::print((e))),
                           "alt2d"=stringlib::subs(strprint(e),
                                                   "\r" = "", "\b"="\n"),
                           "code"=expr2text(e));
    Content::printXML(Content(e), plot::MuPlotML::OutputFile);
    xmlprint::endElement(plot::MuPlotML::OutputFile, "math");
  end_if;
  
  xmlprint::raw(plot::MuPlotML::OutputFile, "\n");
end_proc:
