//   

// bij 26.01.1999

//------------- Baumstruktur ausgeben ----------------
// 
// Aufruf
// 
// output::tree(Tree <, indentdepth> #<, fname>#
//                   <, [char1 = "|", char2 = "+", char3 = "-", char4 = "`", char5 = " "]>
//                   <, {options}>)
//
// Tree        - darzustellender Baum
// indentdepth - Einruecktiefe (DOM_INT)
// fname       - Dateiname fuer die Ausgabe (DOM_STRING)
// [...]       - alternative Zeichen
// options     - Menge von Optionen
// 
// 
// Syntax (Baum)
// call  : \[procname <, calls>\]
// calls : calls <, calls> | call
// 
// 1.5.0 >> output::tree(["f", "f", ["t", ["r", "p", "o"]], "f"])  
//
// f
// |   
// +-- f
// |   
// +-- t
// |   |   
// |   `-- r
// |       |   
// |       +-- p
// |       |   
// |       `-- o
// |   
// `-- f
//


output::tree:=
  proc(tree)
    local printentry, printtreerec, foutdat, indsx, indso, indsp,
          indspe, indspx, indsn, options, indentdepth, i, OUTPUT, NL;
  begin

    OUTPUT:= "";
    NL:= "\n";

    printentry:= // procname, indentstring
      proc(procn, indents = "", indsx = "", indsp = "")
      begin
        if not(contains(options, hold(Small))) and args(0) > 1 then
          OUTPUT:= OUTPUT . indents . indsx . NL;
        end_if;
        if domtype(procn) <> DOM_STRING then
          if domtype(procn) = DOM_PROC then
            procn:= DOM_PROC::print(procn)
          else
            procn:= expr2text(procn)
          end_if
        end_if;
        OUTPUT:= OUTPUT . indents . indsp . procn . NL;
      end_proc:
    
    printtreerec:=
      proc(stree, alist = "")
        local i, pname, calls, call, Ind, Indx;
      begin
        if stree = [] then return() end_if;

        for i from 1 to nops(stree) do
  
          call:= op(stree, i);

          if domtype(call) = DOM_LIST then
            pname:= op(call, 1);
            if nops(call) > 1 then
              calls:= [op(call, 2..nops(call))]
            else
              calls:= []
            end_if
          else
            pname:= call;
            calls:= []
          end_if;
          
          if nops(stree) = i then
            Indx:= indspe;
            Ind:= indsn
          else
            Indx:= indsp;
            Ind:= indsx
          end_if;
          
          printentry(pname, alist, indsx, Indx);
          printtreerec(calls, alist . Ind)
          
        end_for
      end_proc:
    
    // ------------------------------------------------------------ //
    
    if args(0) = 0 then
       return();
    end_if;

    indentdepth:= 4;
    indsx := "|"; // 
    indsp := "+"; // Abzweig
    indspx:= "-"; // Verlaengerung Abzweig rechts
    indspe:= "`"; // letzter Abzweig
    indsn := " "; // 
    indso := " "; // 

    foutdat:= 0; // Ausgabe
    options:= {};

    if testargs() then
      if testtype(tree, DOM_LIST) or
         testtype(tree, DOM_IDENT) or
         testtype(tree, Type::Constant) then
      else
        error("wrong type of 1. arg")
      end_if
    end_if;

    if args(0) > 1 then
      i:= 2;
      while i <= args(0) do
        case type(args(i))
          of DOM_INT do indentdepth:= args(i); break
          of DOM_STRING do
            foutdat:= fopen(args(i));
            if foutdat = FAIL then error("could not open file ".args(i)) end_if;
            break;
          of DOM_LIST do
            indsx:= op(args(i), 1);
            if nops(args(i)) > 1 then indsp:= op(args(i), 2) end_if;
            if nops(args(i)) > 2 then indspx:= op(args(i), 3) end_if;
            if nops(args(i)) > 3 then indspe:= op(args(i), 4) end_if;
            if nops(args(i)) > 4 then indso:= op(args(i), 5) end_if;
            break
          of DOM_SET do
            options:= args(i); break
          of DOM_IDENT do
            if args(i) = hold(Small) then
              options:= options union {args(i)}; break
            else
              error("wrong option")
            end_if
          otherwise
            error("wrong type of ".expr2text(i).". arg")
        end_case;
        i:= i + 1
      end_while
    end_if;

    for i from 1 to indentdepth - 1 do
      indsx:= indsx . indso;
      indsn:= indsn . indso;
      if i = indentdepth - 1 then
        indsp:= indsp . indso;
        indspe:= indspe . indso
      else
        indsp:= indsp . indspx;
        indspe:= indspe . indspx
      end_if
    end_for;

    printentry(op(tree, 1));
    if nops(tree) > 1 then
      printtreerec([op(tree, 2..nops(tree))], "", indsp)
    end_if;
    
    OUTPUT
    
  end_proc: