//      

/* -----------------------------------------------------------
    AmbientLight -- The graphical primitive for an ambient light

    Syntax:
    AmbientLight(<lightIntensity><, op1, op2, ...>)

    lightIntensity  : expression  
    op1, op2, ...   : options of the form 'option = value'

    Example:
    >> plot::AmbientLight(10)

    >> plot::AmbientLight(10, OrthogonalProjection = TRUE)
----------------------------------------------------------------*/ 

plot::createPlotDomain("AmbientLight",
                       "primitive for the ambient light"):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::AmbientLight::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if nops(other) > 1 then
        error("unexpected argument".expr2text(args(2)))
    elif nops(other) = 1 then
      object::LightIntensity := other[1]
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::AmbientLight::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writeAmbientLight(attrib, table(), float(attrib[LightIntensity]));
  end_proc:
