//      

/* -----------------------------------------------------------
    Camera -- The graphical primitive for a camera

    Syntax:
    Camera(position, focalPoint, viewingAngle<, op1, op2, ...>)

    position, focalPoint  : lists of 3 expressions
    viewingAngle          : expression  
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::Camera([1, 2, 3], [4, 5, 6], PI/3)

    >> plot::Camera([1, 2, 3], [4, 5, 6], PI/3,
                    OrthogonalProjection = TRUE)
----------------------------------------------------------------*/ 

plot::createPlotDomain("Camera",
                       "graphical primitive for cameras"):

// methods yet to be implemented:  convert, convert_to, expr

plot::Camera::styleSheet := table(UpVectorX=0.0,
                                  UpVectorY=0.0,
                                  UpVectorZ=1.0):


// here we have to do something
plot::Camera::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if not contains({0, 3}, nops(other)) then
      error("expecting 2 lists and an expression")
    end_if;
    
    if testargs() and nops(other) = 3 then
      if not testtype(other[1],
                     Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
        error("expecting a list of 3 expressions as 1st argument")
      end_if;
      
      if not testtype(other[2],
                      Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
        error("expecting a list of 3 expressions as 2nd argument")
      end_if;
      
      if not testtype(other[3], Type::Arithmetical) and
        not (other[3])::dom::hasProp(Cat::Matrix)=TRUE then
        error("expecting an expressions as 3rd argument")
      end_if;
    end_if;
    
    if nops(other) = 3 then
      object::Position     := other[1];
      object::FocalPoint   := other[2];
      object::ViewingAngle := other[3];
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Camera::doPlotStatic:=
proc(out, obj, attrib, inherited)
  local scal, viewdir, newup, normalize;
begin
  normalize := proc(A)
		 local n;
	       begin
		 A := float(A);
		 n := sqrt(A[1]^2+A[2]^2+A[3]^2);
		 if iszero(n) then A
		 else
		   eval(map(A, `/`, n));
		 end_if;
	       end_proc;
  
  if attrib[KeepUpVector] = TRUE or
     obj::CurrentUpVector = FAIL or
     iszero(attrib[TimeValue] - attrib[TimeBegin]) then
    dom::extslot(obj, "CurrentUpVector",
		 float([attrib[UpVectorX],
			attrib[UpVectorY],
			attrib[UpVectorZ]]));
  end_if;
  if attrib[KeepUpVector] = FALSE then
    viewdir := normalize([attrib[FocalPointX]-attrib[PositionX],
			  attrib[FocalPointY]-attrib[PositionY],
			  attrib[FocalPointZ]-attrib[PositionZ]]);
    scal := obj::CurrentUpVector[1]*viewdir[1]
	  + obj::CurrentUpVector[2]*viewdir[2]
	  + obj::CurrentUpVector[3]*viewdir[3];
    newup := zip(obj::CurrentUpVector, viewdir, (a,b) -> a-scal*b);
    scal := sqrt(newup[1]^2 + newup[2]^2 + newup[3]^2);
    if iszero(scal) then
      if iszero(viewdir[1]) and iszero(viewdir[2]) then
	dom::extslot(obj, "CurrentUpVector",
		     [1.0, 0.0, 0.0]);
      else
	newup := [-viewdir[1]*viewdir[3],
		  -viewdir[2]*viewdir[3],
		  1.0-viewdir[3]^2];
	scal := sqrt(newup[1]^2 + newup[2]^2 + newup[3]^2);
	dom::extslot(obj, "CurrentUpVector",
		     float(map(newup, `/`, scal)));
      end_if;
    else
    dom::extslot(obj, "CurrentUpVector",
		 float(map(newup, `/`, scal)));
    end_if;
  end_if;

  out::writeCamera(attrib, table(), float(attrib[PositionX]),
                                    float(attrib[PositionY]),
                                    float(attrib[PositionZ]),
                                    float(attrib[FocalPointX]),
                                    float(attrib[FocalPointY]),
                                    float(attrib[FocalPointZ]),
                                    obj::CurrentUpVector,
                                    attrib[KeepUpVector],
                                    float(attrib[ViewingAngle]));
end_proc:

plot::Camera::print :=
  obj -> hold(plot::Camera)(obj::Position, 
                            obj::FocalPoint,
                            obj::ViewingAngle,
                            dom::printAttributes(obj, {Position, FocalPoint, ViewingAngle})):
