//      

/* -----------------------------------------------------------
    Canvas -- The Canvas

    Syntax:
    Canvas(x, y<, op1, op2, ...>)

    x, y         : plot objects
    op1, op2, ...: plot options of the form 'option = value'
----------------------------------------------------------------*/ 

plot::createPlotDomain("Canvas", "the Canvas"):

plot::Canvas::hiddenSlots({CurrentTime}):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::Canvas::new:=
  proc()
    local object, other, children, dimensions, scene, scenes,
          styleEntries, hints, dummy, sceneType;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if nops(other) <> 0 then
      error("unexpected arguments: ".expr2text(op(other)));
    end_if;

    children := object::children;

    if nops(children) = 0 then
      // empty plot, return a 2D scene
      object::children := [plot::Scene2d()];
      return(dom::checkObject(object));
    end_if;
    
    dimensions := map({op(children)}, x -> x::dom::dimension);
    if nops(dimensions) <> 1 then
      error("dimension mismatch")
    end_if;
    
    scene := "Scene".op(dimensions)."d";
    sceneType := slot(plot, scene);
    
    [scenes, other, dummy] := split(children, testtype, sceneType);

    dummy := map({op(children)}, x -> x::dom::objType) intersect
             {"Canvas"};
    if dummy <> {} then
      error("Illegal argument plot::".op(dummy, 1))
    end_if;
    
    if other <> [] then
      // optional attributes for children are now in styleEntries,
      // pass them to the scene creation
      styleEntries := op(map((extop(object, 1))::styleEntries, plot::ExprAttribute::getExpr));
      // same for hints (optional arguments for children given to Canvas)
      hints := {op(map((extop(object, 1))::hints, plot::ExprAttribute::getExpr))};
      // ignore internal _-attributes
      hints := op(select(hints, x -> ("".op(x,1))[length("".op(x,1))] <> "_")):
      scenes := scenes.[slot(plot, scene)(op(other), styleEntries, hints)];
    end_if;

    object::children := scenes;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:
