//      

/* -----------------------------------------------------------
    ClippingBox -- The graphical primitive for a clipping box

    Syntax:
    ClippingBox(range1, range2, range3<, op1, op2, ...>)

    range1, range2, range3 : ranges of expressions
    op1, op2, ...          : options of the form 'option = value'

    Example:
    >> plot::ClippingBox(-5..5, -5..5, -5..5)

----------------------------------------------------------------*/ 

plot::createPlotDomain("ClippingBox",
                       "graphical primitive for a clipping box"):

// methods yet to be implemented:  convert, convert_to, expr


// here we have to do something
plot::ClippingBox::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() then
      if nops(other) > 3 then
         error("unexpected argument: ".expr2text(other[4]));
      end_if;
      if nops(other) = 3 then
        if not testtype(other,
                        Type::ListOf("_range", 3, 3)) then
          error("expecting 3 ranges")
        end_if;
  
        if not testtype(map(op(other), op),
                        Type::SequenceOf(Type::Arithmetical, 6, 6)) then
          error("expecting 3 ranges of expressions")
        end_if;
      end_if;
    end_if;

    if nops(other) = 2 then
      if not testtype(other[1],
                   Type::ListOf(Type::Arithmetical, 3, 3)) then
        if (other[1])::dom::hasProp(Cat::Matrix) = TRUE then
          other[1]:= [op(other[1])];
        else
          error("expecting a list of 3 expressions or a matrix as 1st argument")
        end_if;
      end_if;
      if not testtype(other[2],
                   Type::ListOf(Type::Arithmetical, 3, 3)) then
        if (other[2])::dom::hasProp(Cat::Matrix) = TRUE then
          other[2]:= [op(other[2])];
        else
          error("expecting a list of 3 expressions or a matrix as 2nd argument")
        end_if;
      end_if;
    end_if;

    if nops(other) = 3 then
      object::XRange := other[1];
      object::YRange := other[2];
      object::ZRange := other[3];
    end_if;

    if nops(other) = 2 then
       object::XRange := other[1][1]..other[2][1];
       object::YRange := other[1][2]..other[2][2];
       object::ZRange := other[1][3]..other[2][3];
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::ClippingBox::print :=
obj -> hold(plot::ClippingBox)(obj::XRange, obj::YRange, obj::ZRange,
                               dom::printAttributes(obj, {XRange,YRange, ZRange})):

plot::ClippingBox::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writeClippingBox(attrib, table(), float(attrib[XMin]),
                              float(attrib[XMax]),
                              float(attrib[YMin]),
                              float(attrib[YMax]),
                              float(attrib[ZMin]),
                              float(attrib[ZMax]));
  end_proc:
