//      

/* -----------------------------------------------------------
    CoordinateSystem3d -- The CoordinateSystem3d

    Syntax:
    CoordinateSystem3d(x, y<, op1, op2, ...>)

    x, y         : plot objects
    op1, op2, ...: plot options of the form 'option = value'
----------------------------------------------------------------*/ 

plot::createPlotDomain("CoordinateSystem3d", "primitive for 3D coordinate systems"):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::CoordinateSystem3d::new:=
  proc()
    local object, other, children, dimensions, dummy;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if nops(other) <> 0 then
      error("unexpected arguments: ".expr2text(op(other)));
    end_if;

    children := object::children;

    if nops(children) = 0 then
      // empty plot
      return(dom::checkObject(object))
    end_if;
    
    dimensions := map({op(children)}, x -> x::dom::dimension);
    if nops(dimensions) <> 1 or dimensions <> {3} then
      error("only 3-dimensional plot objects allowed")
    end_if;

    dummy := map({op(children)}, x -> x::dom::objType) intersect
             {"Canvas", "Scene2d", "Scene3d",
              "CoordinateSystem2d", "CoordinateSystem3d"};
    if dummy <> {} then
      error("Illegal argument plot::".op(dummy, 1))
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::CoordinateSystem3d::styleSheet := table(Axes=Boxed,
                                              XAxisTitleAlignment = Center,
                                              YAxisTitleAlignment = Center,
                                              ZAxisTitleAlignment = Center,
                                              AxesTips = FALSE):
