//      

/* -----------------------------------------------------------
    DistantLight -- The graphical primitive for a distant light

    Syntax:
    DistantLight(position, target<, lightIntensity><, op1, op2, ...>)

    position, target      : lists of 3 expressions
    lightIntensity        : expression  
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::DistantLight([1, 2, 3], [4, 5, 6], 10)

    >> plot::DistantLight([1, 2, 3], [4, 5, 6], 10,
                    OrthogonalProjection = TRUE)
----------------------------------------------------------------*/ 

plot::createPlotDomain("DistantLight",
                       "primitive for distant light"):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::DistantLight::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() then
      if not contains({0, 2, 3}, nops(other)) then
        error("expecting 2 lists")
      end_if;

      if nops(other) > 0 then
        if not testtype(other[1],
                        Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
          error("expecting a list of 3 expressions as 1st argument")
        end_if;
        
        if not testtype(other[2],
                        Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
          error("expecting a list of 3 expressions as 2nd argument")
        end_if;
        
        if nops(other) = 3 then
          if not testtype(other[3], Type::Arithmetical) then
            error("expecting an expressions as 3rd argument")
          end_if;
        end_if;
     end_if;
    end_if;
    
    if nops(other) > 0 then
      object::Position       := other[1];
      object::Target         := other[2];
    end_if;
    if nops(other) = 3 then
      object::LightIntensity := other[3];
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::DistantLight::print :=
obj -> hold(plot::DistantLight)(obj::Position, obj::Target,
                                dom::printAttributes(obj, {Position, Target})):

plot::DistantLight::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writeDistantLight(attrib, table(), float(attrib[PositionX]),
                                            float(attrib[PositionY]),
                                            float(attrib[PositionZ]),
                                            float(attrib[TargetX]),
                                            float(attrib[TargetY]),
                                            float(attrib[TargetZ]),
                                            float(attrib[LightIntensity]));
  end_proc:
