//      

/* -----------------------------------------------------------
    PointLight -- The graphical primitive for a point light

    Syntax:
    PointLight(position<, lightIntensity><, op1, op2, ...>)

    position              : lists of 3 expressions
    lightIntensity        : expression  
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::PointLight([1, 2, 3], 10)

    >> plot::PointLight([1, 2, 3], 10,
                        OrthogonalProjection = TRUE)
----------------------------------------------------------------*/ 

plot::createPlotDomain("PointLight",
                       "primitive for point lights"):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::PointLight::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() then
      if not contains({0, 1, 2}, nops(other)) then
        error("expecting a list and an expression")
      end_if;
      
      if nops(other) > 0 then
        if not testtype(other[1],
                        Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
          error("expecting a list of 3 expressions as 1st argument")
        end_if;

        if nops(other) > 1 then
          if not testtype(other[2], Type::Arithmetical) then
            error("expecting an expressions as 2nd argument")
          end_if;
        end_if;
      end_if;
    end_if;    /* testargs */
   
    if nops(other) > 0 then
      object::Position       := other[1];
    end_if;
    if nops(other) = 2 then
      object::LightIntensity := other[2];
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::PointLight::print :=
  obj -> hold(plot::PointLight)(obj::Position,
                                dom::printAttributes(obj, {Position})):

plot::PointLight::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writePointLight(attrib, table(), float(attrib[PositionX]),
                                          float(attrib[PositionY]),
                                          float(attrib[PositionZ]),
                                          float(attrib[LightIntensity]));
  end_proc:
