// 

/* -----------------------------------------------------------
 
 Reflect2d -- reflection about a straight line
 
 Syntax (to conform to Line2d):
 Reflect2d(point1, point2, <options>, <objects>)
 
 point1, point2   : lists of 2 expressions
 
 plot(plot::Reflect2d([1,1], [2, a], a=-2..2, plot::Function2d(sin)));
 
 plot(plot::Reflect2d([0,0], plot::Point2d([1,1])));
 
----------------------------------------------------------- */

plot::createPlotDomain("Reflect2d",
                       "Reflection about a straight line",
                       2,
                       [FromX, FromY, From, ToX, ToY, To,
                        Matrix2d, ShiftX, ShiftY, Shift],
                       "Transform"):
plot::objectHierarchy["Reflect2d"] := plot::objectHierarchy["Rotate2d"]:
//-----------------------------------------------------------------
plot::Reflect2d::hints := {Scaling = Constrained}: 
//-----------------------------------------------------------------
plot::Reflect2d::hiddenSlots({Matrix2d, Shift, ShiftX, ShiftY}):
// rebuild InspectorEntry without hidden slots
plot::buildInspectorEntry("Reflect2d", 2,
                           [FromX, FromY, From, ToX, ToY, To], "Transform"):
//-----------------------------------------------------------------

plot::Reflect2d::new :=
proc()
  local object, other, i;
begin
  object := dom::checkArgs([], args());
  
  other := object::other;
  
  // convert matrix cols to list of coordinates
  if nops(other) > 0 and (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
    if nops(other[1]) = 2 then
       // other[1] provides 'From' but not 'To'
       other[1]:= [op(other[1])]
    else
       // other[1] provides 'From' and to 'To'
       other[1] := [op(linalg::col(other[1],i))] $ i=1..linalg::ncols(other[1])
    end_if;
  end_if;
  
  if nops(other) > 1 and (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
    other[2]:= [op(other[2])]
//  other[2] := [op(linalg::col(other[2],i))] $ i=1..linalg::ncols(other[2])
  end_if;
  
  if nops(other) > 0 and (other[1])::dom = plot::Line2d then
    other[1] := (other[1])::From, (other[1])::To;
  end_if;
  
  if nops(other) > 0 then
    case nops(other)
      of 1 do
        object::From := other[1];
        object::To := other[1];
        break;
        
      of 2 do
        object::From := other[1];
        object::To := other[2];
        break;
        
      otherwise
        error("Unexpected argument ".expr2text(other[3]));
    end_case;
  end_if;
  
  // calculate internal values
  dom::changeNotifier(object, "ToX"=object::ToX);
  
  map(object::children,
      c -> if c::dom::dimension <> 2 then
             context(hold(error)("only 2-dimensional plot objects allowed"))
           end_if);
  
  dom::checkObject(object);
end_proc:

plot::Reflect2d::changeNotifier :=
proc(obj, eq)
  local slotName, newval, n, x0;
begin
  [slotName, newval] := [op(eq)];
  case slotName
    of "FromX" do
    of "FromY" do
    of "From"  do
    of "ToX"   do
    of "ToY"   do
    of "To"    do
      dom::extslot(obj, slotName, newval);
      // normal:
      n := [obj::ToY - obj::FromY, obj::FromX - obj::ToX];
      if iszero(n[1]) and iszero(n[2]) then
        dom::extslot(obj, "Matrix2d", [-1, 0, 0, -1]);
        dom::extslot(obj, "ShiftX", 2*obj::FromX);
        dom::extslot(obj, "ShiftY", 2*obj::FromY);
      else
         n := [n[1]/sqrt(n[1]^2+n[2]^2), n[2]/sqrt(n[1]^2+n[2]^2)];
         dom::extslot(obj, "Matrix2d",
                      [(n[2]-n[1])*(n[2]+n[1]), -2*n[1]*n[2],
                       -2*n[1]*n[2], (n[1]-n[2])*(n[2]+n[1])]); 
         x0 := 2*n[1]*obj::FromX + 2*n[2]*obj::FromY;
         dom::extslot(obj, "ShiftX", x0*n[1]);
         dom::extslot(obj, "ShiftY", x0*n[2]);
      end_if;
      return(FALSE);
  end_case;
  return(TRUE);
end_proc:

plot::Reflect2d::print :=
proc(obj)
begin
  if obj::From = obj::To then
    hold(plot::Reflect2d)(obj::From, op(obj::children),
                          dom::printAttributes(obj, {From, To})):
  else
    hold(plot::Reflect2d)(obj::From, obj::To, op(obj::children),
                          dom::printAttributes(obj, {From, To})):
  end_if:
end_proc:


