//      

/* -----------------------------------------------------------
    Scale3d -- 3D scaling

    Syntax:
    Scale3d(scale<, op1, op2, ...>)

    scale        : scale vector - list with 3 components
    op1, op2, ...: plot options of the form 'option = value'
----------------------------------------------------------------*/ 

plot::createPlotDomain("Scale3d", "3D scaling"):

plot::Scale3d::styleSheet := table(ShiftX=0, ShiftY=0, ShiftZ=0):

// methods yet to be implemented:  convert, convert_to, expr

plot::Scale3d::hiddenSlots({Matrix3d, Shift, ShiftX, ShiftY, ShiftZ}):

// here we have to do something
plot::Scale3d::new:=
  proc()
    local object, other, children, dimensions;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if not contains({0,1}, nops(other)) then
      error("unexpected arguments: ".expr2text(other[2]));
    end_if;

    if testargs() and nops(other) = 1 then 
      if (other[1])::dom::hasProp(Cat::Matrix) = TRUE then
        other[1]:= [op(other[1])];
      end_if;
      if not testtype(other[1],
                      Type::ListOf(Type::Arithmetical, 3, 3)) then
        error("expecting a list of 3 expressions or a matrix");
      end_if;
    end_if;

    if nops(other) = 1 then 
      object::Scale    := other[1];
      object::Matrix3d := [other[1][1],      0,           0,
                                0,      other[1][2],      0,
                                0,           0,      other[1][3]]      
    end_if;
 
    children := object::children;
    if nops(children) = 0 then
      // empty Scale3d
      return(dom::checkObject(object))
    end_if;
    
    dimensions := map({op(children)}, x -> x::dom::dimension);
    if nops(dimensions) <> 1 or dimensions <> {3} then
      error("only 3-dimensional plot objects allowed")
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Scale3d::changeNotifier :=
  proc(obj, ass)
    local slotName, newval;
  begin
    [slotName, newval] := [op(ass)];
    case slotName
      of "ScaleX" do
      of "ScaleY" do
      of "ScaleZ" do
      of "Scale" do
        dom::extslot(obj, slotName, newval);
        obj::Matrix3d:= [obj::ScaleX,      0,           0,
                              0,      obj::ScaleY,      0,
                              0,           0,      obj::ScaleZ];
        return(FALSE); // we've done everything
        break;
    end_case;
    return(TRUE); // go ahead
  end_proc:
  
plot::Scale3d::print :=
  obj -> hold(plot::Scale3d)(obj::Scale, op(obj::children),
                             dom::printAttributes(obj, {Scale})):
