//      

/* -----------------------------------------------------------
    Scene2d -- The Scene2d

    Syntax:
    Scene2d(x, y<, op1, op2, ...>)

    x, y         : plot objects
    op1, op2, ...: plot options of the form 'option = value'
----------------------------------------------------------------*/ 

plot::createPlotDomain("Scene2d", "primitive for 2D scenes"):

plot::Scene2d::styleSheet := table(HeaderFont="'sans-serif' 12",
                                   FooterFont="'sans-serif' 12"):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::Scene2d::new:=
  proc()
    local object, other, children, dimensions, coords, styleEntries, hints,
          dummy, views;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if nops(other) <> 0 then
      error("unexpected arguments: ".expr2text(op(other)));
    end_if;

    children := object::children;

    if nops(children) = 0 then
      // empty plot
      object::children := [plot::CoordinateSystem2d()];
      return(dom::checkObject(object));
    end_if;
    
    dimensions := map({op(children)}, x -> x::dom::dimension);
    if nops(dimensions) <> 1 or dimensions <> {2} then
      error("only 2-dimensional plot objects allowed")
    end_if;
    
    [coords, other, dummy] := split(children, testtype,
                                   plot::CoordinateSystem2d);
    [views, other, dummy] := split(other, testtype, plot::View2d);
    coords := views.coords;

    dummy := map({op(children)}, x -> x::dom::objType) intersect
             {"Canvas", "Scene2d", "Scene3d"};
    if dummy <> {} then
      error("Illegal argument plot::".op(dummy, 1))
    end_if;
    
    if other <> [] then
      // optional attributes for children are now in styleEntries,
      // pass them to the scene creation
      styleEntries := op(map((extop(object, 1))::styleEntries, plot::ExprAttribute::getExpr));
      // same for hints (optional arguments for children given to Scene2d)
      hints := {op(map((extop(object, 1))::hints, plot::ExprAttribute::getExpr))};
      // ignore internal _-attributes
      hints := op(select(hints, x -> ("".op(x,1))[length("".op(x,1))] <> "_")):
      coords := coords.[plot::CoordinateSystem2d(op(other),
                                                 styleEntries, hints)];
    end_if;
    object::children := coords;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:
