//      1

/* -----------------------------------------------------------
    Ellipse2d -- The graphical primitive for 2D ellipses

    Syntax:
    Ellipse2d(semiAxisX, semiAxisY, <, center><, op1, op2, ...>)

    semiAxis{X,Y}         : expressions
    center                : list of 2 expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::Ellipse2d(2, 3)

    >> plot::Ellipse2d(2, 3, [1, 2])
----------------------------------------------------------------*/ 

plot::createPlotDomain("Ellipse2d",
                       "graphical primitive for 2D ellipses"):

//------------------------------------------------------------------------
plot::Ellipse2d::styleSheet := table(
      CenterX   = 0,
      CenterY   = 0,
      SemiAxisX = 2,
      SemiAxisY = 1,
      Filled  = FALSE
):

plot::Ellipse2d::setPrimaryColor(LineColor):
//------------------------------------------------------------------------

// Hints for parents:
plot::Ellipse2d::hints := {Scaling = Constrained}:

// methods yet to be implemented:  convert, convert_to, expr


// here we have to do something
plot::Ellipse2d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() and nops(other) > 0 then
      if nops(other) > 3 then
        error("unexpected argument: ".expr2text(other[4]))
      end_if;

      if not testtype(other[1], Type::Arithmetical) then
        error("1st argument: expecting an expression (the horizontal semi-axis)")
      end_if;

      if nops(other) > 1 and not testtype(other[2], Type::Arithmetical) then
        error("2nd argument: expecting an expression (the vertical semi-axis)")
      end_if;

      if nops(other) = 3 and
        not testtype(other[3],
                     Type::ListOf(Type::Arithmetical, 2, 2)) and
        not (other[3])::dom::hasProp(Cat::Matrix)=TRUE  then
        error("3rd argument: expecting a list of 2 expressions (the center)")
      end_if;
    end_if;
    
    if nops(other) > 0 then
      object::SemiAxisX := other[1]:
      if nops(other) > 1 then
        object::SemiAxisY := other[2]:
      end_if;
      if nops(other) = 3 then
        object::Center := other[3];
      end_if;
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Ellipse2d::print :=
  obj -> hold(plot::Ellipse2d)(obj::SemiAxisX, obj::SemiAxisY, obj::Center):

plot::Ellipse2d::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writeArc2d(attrib, table(), float(attrib[CenterX]), float(attrib[CenterY]),
      float(attrib[SemiAxisX]), float(attrib[SemiAxisY]));
  end_proc:
