//      1

/* -----------------------------------------------------------
    Ellipse3d -- The graphical primitive for 2D ellipses

    Syntax:
    Ellipse3d(semiAxisX, semiAxisY,<, center><, normal><, op1, op2, ...>)

    semiAxis{X,Y}         : expressions
    center                : list of 3 expressions
    normal                : list of 3 expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::Ellipse3d(2, 3)

    >> plot::Ellipse3d(2, 3, [1, 2, 3])

    >> plot::Ellipse3d(2, 3, [1, 2, 3], [1, 1, 1])

    >> plot::Ellipse3d(2, 3, [1, 2, 3], [0, 1, 0], Filled)

    >> plot::Ellipse3d(2, 3, [1, 2, 3], [0, 1, 0], Filled, FillColorType=Dichromatic)

    >> plot::Ellipse3d(2, 3, [1, 2, 3], [0, 1, 0], Filled, FillColor2=RGB::Yellow, FillColorType=Dichromatic)

----------------------------------------------------------------*/ 

plot::createPlotDomain("Ellipse3d",
                       "graphical primitive for 3D ellipses",
                       3,
       [CenterX, CenterY, CenterZ, Center, 
        SemiAxisX, SemiAxisY, SemiAxes,
        NormalX, NormalY, NormalZ, Normal, 
        LineColor, LineColor2, LineColorType, LineWidth, LineStyle, LinesVisible,
        LineColorDirectionX, LineColorDirectionY, LineColorDirectionZ, LineColorDirection,
        Filled, FillColor, FillColor2, FillColorType,
        FillColorDirectionX, FillColorDirectionY, FillColorDirectionZ, FillColorDirection]
):

//------------------------------------------------------------------------
plot::Ellipse3d::styleSheet := table(
      CenterX = 0,
      CenterY = 0,
      CenterZ = 0,
      SemiAxisX = 2,
      SemiAxisY = 1,
      NormalX = 0,
      NormalY = 0,
      NormalZ = 1,
      Filled  = FALSE,
      FillColorType = Flat,
   // LineColor = RGB::Black.[0.25],  // primarily, this is a line object!!
      FillColor = RGB::LightBlue,
      LineColorDirectionY=0
):

plot::Ellipse3d::setPrimaryColor(LineColor):
//------------------------------------------------------------------------
// Hints for parents:
plot::Ellipse3d::hints := {Scaling = Constrained}:
//-----------------------------------------------------------------------------------
// methods yet to be implemented:  convert, convert_to, expr
//-----------------------------------------------------------------------------------
plot::Ellipse3d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() and nops(other) > 0 then
      if nops(other) > 4 then
        error("unexpected argument: ".expr2text(other[4]))
      end_if;

      if not testtype(other[1], Type::Arithmetical) then
        error("1st argument: expecting an expression (the x semi-axis)")
      end_if;

      if nops(other) > 1 and 
         not testtype(other[2], Type::Arithmetical) then
        error("2nd argument: expecting an expression (the y semi-axis)")
      end_if;

      if nops(other) > 2 and
        not testtype(other[3], Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[3])::dom::hasProp(Cat::Matrix)=TRUE  then
        error("3rd argument: expecting a list of 3 expressions (the center)")
      end_if;

      if nops(other) > 3 and
        not testtype(other[3], Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[3])::dom::hasProp(Cat::Matrix)=TRUE  then
        error("4rd argument: expecting a list of 3 expressions (the normal)")
      end_if;
    end_if;
    
    if nops(other) > 0 then
      object::SemiAxisX := other[1]:
      if nops(other) > 1 then
        object::SemiAxisY := other[2]:
      end_if;
      if nops(other) > 2 then
        object::Center := other[3];
      end_if;
      if nops(other) > 3 then
        object::Normal := other[4];
      end_if;
    end_if;
;     
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Ellipse3d::print :=
  obj -> if obj::Normal = FAIL then
           hold(plot::Ellipse3d)(obj::SemiAxisX, obj::SemiAxisY, obj::Center):
         else
           hold(plot::Ellipse3d)(obj::SemiAxisX, obj::SemiAxisY, obj::Center, obj::Normal):
         end_if:

plot::Ellipse3d::doPlotStatic:=
  proc(out, obj, attrib, inherited)
    local arc, arcattr;
  begin
   arcattr:= out::fixAttributes(attrib, plot::Arc3d);
   arc    := plot::Arc3d(op(arcattr), Angle = 0, AngleBegin = 0, AngleEnd = 2*PI);
   out::new(arc, inherited, Raw);
  end_proc:
