/* -----------------------------------------------------------
    Ellipsoid -- The graphical primitive for 3D ellipsoids

    Syntax:
    plot::Ellipsoid(a, b, c, <, center><, op1, op2, ...>)

    a, b, c          : lengths of the semi axes: expressions
    center           : list of 3 expressions
    op1, op2, ...    : options of the form 'option = value'

    Example:
    >> plot::Ellipsoid(1, 2, 3, [0, 0, 0])
----------------------------------------------------------------*/ 
plot::createPlotDomain("Ellipsoid",
                       "graphical primitive for 3D ellipsoids", 3,
                       [CenterX, CenterY, CenterZ, Center,
                        SemiAxisX, SemiAxisY, SemiAxisZ, SemiAxes,
                        FillColor, Color, Shading]):
//-----------------------------------------------------------------------------
plot::Ellipsoid::styleSheet := table(
      FillColor = RGB::LightBlue,
      CenterX      = 0,
      CenterY      = 0,
      CenterZ      = 0,
      SemiAxisX    = 1,
      SemiAxisY    = 2,
      SemiAxisZ    = 3
):
//------------------------------------------------------------------------
// Hints for parents:
plot::Ellipsoid::hints := {
      Scaling = Constrained
}:
//------------------------------------------------------------------------
// methods yet to be implemented:  convert, convert_to, expr
//-----------------------------------------------------------------------------
plot::Ellipsoid::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() and nops(other) > 0 then
      if nops(other) > 4 then
        error("unexpected argument: ".expr2text(other[5]))
      end_if;

      if not testtype(other[1], Type::Arithmetical) then
        error("1st argument: expecting an expression (the length of the semi axis in x direction)")
      end_if;
      if nops(other) > 1 and not testtype(other[2], Type::Arithmetical) then
        error("2nd argument: expecting an expression (the length of the semi axis in y direction)")
      end_if;
      if nops(other) > 2 and not testtype(other[3], Type::Arithmetical) then
        error("3rd argument: expecting an expression (the length of the semi axis in z direction)")
      end_if;
      if nops(other) = 4 and
        not testtype(other[4],
                     Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[4])::dom::hasProp(Cat::Matrix) = TRUE  then
        error("4th argument: expecting a list of 3 expressions (the center)")
      end_if;
    end_if;
    
    if nops(other) > 0 then
      object::SemiAxisX := other[1];
      if nops(other) > 1 then
        object::SemiAxisY := other[2];
      end_if;
      if nops(other) > 2 then
        object::SemiAxisZ := other[3];
      end_if;
      if nops(other) = 4 then
        object::Center := other[4];
      end_if;
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:
//-----------------------------------------------------------------
plot::Ellipsoid::print :=
  obj -> hold(plot::Ellipsoid)(obj::SemiAxisX, 
                               obj::SemiAxisY, 
                               obj::SemiAxisZ,
                               obj::Center):
//-----------------------------------------------------------------
plot::Ellipsoid::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writeEllipsoid(attrib, table(), float(attrib[CenterX]),
      float(attrib[CenterY]), float(attrib[CenterZ]),
      float(attrib[SemiAxisX]), float(attrib[SemiAxisY]), float(attrib[SemiAxisZ]));
/*    rx:=float(attrib[SemiAxisX]);
    ry:=float(attrib[SemiAxisY]);
    rz:=float(attrib[SemiAxisZ]);
    plot::MuPlotML::beginElem("Ellipsoid",
                              "SemiAxisX" = rx,
                              "SemiAxisY" = ry,
                              "SemiAxisZ" = rz,
                              "Center" = (float(attrib[CenterX]),
                                          float(attrib[CenterY]),
                                          float(attrib[CenterZ])),
                              Empty);
  return([ float(attrib[CenterX])-rx ..float(attrib[CenterX])+rx,
           float(attrib[CenterY])-ry ..float(attrib[CenterY])+ry,
           float(attrib[CenterZ])-rz ..float(attrib[CenterZ])+rz
         ]);*/
  end_proc:
