// 

/* plot::Inequality



*/

plot::createPlotDomain("Inequality",
                       "graphical primitive for 2D inequality plots",
                       2,
                       [XName, XMin, XMax, XMesh,
                        YName, YMin, YMax, YMesh,
                        Mesh,
                        LinesVisible, LineStyle, LineWidth, AntiAliased,
                        LineColor, 
                        [FillColorTrue, ["Optional", RGB::Green],
                         [["Style", "Surface"], "Prop", "Color",
                          "Fill color for ``true.''", FALSE]],
                        [FillColorFalse, ["Optional", RGB::Red],
                         [["Style", "Surface"], "Prop", "Color",
                          "Fill color for ``false.''", FALSE]],
                        [FillColorUnknown, ["Optional", RGB::Black],
                         [["Style", "Surface"], "Prop", "Color",
                          "Fill color for ``unknown.''", FALSE]],
                        FillPattern,
                        [Inequalities, ["Mandatory", NIL],
                         ["Definition", "ExprSeq", FAIL,
                          "The inequalities to be fulfilled.", TRUE]]
                       ]):

plot::Inequality::styleSheet := table(FillPattern = Solid,
                                      LinesVisible = FALSE,
                                      AntiAliased = FALSE,
                                      XMesh=256, YMesh=256):

plot::Inequality::hints := {AxesInFront = TRUE, GridInFront = TRUE}:

plot::Inequality::new :=
  proc()
    local object, other;
  begin
    object := dom::checkArgs(["X", "Y"], args());
    
    other := object::other;
    
    if nops(other) > 0 then
      case domtype(other[1])
        of DOM_SET do
          other[1] := [op(other[1])];
          break;
        of DOM_EXPR do
          other[1] := [other[1]];
          break;
      end_case;
      object::Inequalities := other[1];
    end_if;
    if nops(other) > 1 then
      error("unexpected argument ".expr2text(other[2]));
    end_if;
        
    dom::checkObject(object);
  end_proc:
  
plot::Inequality::print := (ie) -> hold(plot::Inequality)(ie::Inequalities,
                                                          ie::XName = ie::XRange,
                                                          ie::YName = ie::YRange):

plot::Inequality::doPlot :=
  proc(out, fn, next_div_is_u,
       u, umin, umax, usubdivs,
       v, vmin, vmax, vsubdivs,
       attributes)
    local uiv, viv, cursign, doSubdiv;
  begin
    doSubdiv := proc()
                  local fac, i, ustep;
                begin
                  if next_div_is_u then
                    fac := usubdivs[1];
                    usubdivs[2] := usubdivs[2] - 1;
                    if usubdivs[2] = 0 then
                      delete usubdivs[2], usubdivs[1];
                    end_if;
                    ustep := (umax-umin)/fac;
                    for i from 0 to fac-1 do
                      dom::doPlot(out, fn, FALSE,
                                  u, umin+i*ustep, umin+(i+1)*ustep, usubdivs,
                                  v, vmin, vmax, vsubdivs,
                                  attributes);
                    end_for;
                  else
                    fac := vsubdivs[1];
                    vsubdivs[2] := vsubdivs[2] - 1;
                    if vsubdivs[2] = 0 then
                      delete vsubdivs[2], vsubdivs[1];
                    end_if;
                    ustep := (vmax-vmin)/fac;
                    for i from 0 to fac-1 do
                      dom::doPlot(out, fn, TRUE,
                                  u, umin, umax, usubdivs,
                                  v, vmin+i*ustep, vmin+(i+1)*ustep, vsubdivs,
                                  attributes);
                    end_for;
                  end_if;
                end_proc:

    if nops(vsubdivs) = 0 then
      next_div_is_u := TRUE;
    end_if;
    if nops(usubdivs) = 0 then
      next_div_is_u := FALSE;
      if nops(vsubdivs) = 0 then
        // can't subdivide any more
        doSubdiv := proc()
                    begin
                      // plot unknown rectangle
                      out::writePoly2d(attributes,
                        table("Closed"=TRUE, "Filled"=TRUE, "FillColor"=float(attributes[FillColorUnknown])),
                        [[umin,vmin],[umin,vmax],[umax,vmax],[umax,vmin]]);
                    end_proc:
      end_if;
    end_if;
    
    uiv := umin...umax;
    viv := vmin...vmax;
    
    
    cursign := map(fn, f -> sign(hull(interval::evalSimple(f, u=uiv, v=viv))));
    
    if contains(cursign, hull(-1))>0 then
      // plot neg. rectangle
      out::writePoly2d(attributes,
        table("Closed"=TRUE, "Filled"=TRUE, "FillColor"=float(attributes[FillColorFalse])),
        [[umin,vmin],[umin,vmax],[umax,vmax],[umax,vmin]]);
    elif cursign = [hull(1)$nops(fn)] then
      // plot pos. rectangle
      out::writePoly2d(attributes,
        table("Closed"=TRUE, "Filled"=TRUE, "FillColor"=float(attributes[FillColorTrue])),
        [[umin,vmin],[umin,vmax],[umax,vmax],[umax,vmin]]);
    else
      doSubdiv();
    end_if;
    return();
  end_proc:

plot::Inequality::doPlotStatic :=
  proc(out, o, attributes, inheritedAttributes)
    local u, umin, umax, umesh, usubdivs, 
          v, vmin, vmax, vmesh, vsubdivs,
          ineqs;
  begin
    u        := attributes[XName];
    umin     := attributes[XMin];
    umax     := attributes[XMax];
    umesh    := attributes[XMesh];
    v        := attributes[YName];
    vmin     := attributes[YMin];
    vmax     := attributes[YMax];
    vmesh    := attributes[YMesh];
    ineqs    := attributes[Inequalities];
    
    if map({op(ineqs)},
           ie -> bool(type(ie) in {"_less", "_leequal", "_equal"}))
       <> {TRUE} then
      error("inequalities must contain only <, <=, or =-expressions");
    end_if;
    
    // transform inequalities into interval-expressions whose signs are relevant
    ineqs := map(ineqs, x->interval(op(x,2)-op(x,1)));
    
//    usubdivs := stdlib::ifactor(usubmesh+1);
//    delete usubdivs[1];
//    usubdivs := stdlib::ifactor(umesh).usubdivs;
//    delete usubdivs[1];
//    vsubdivs := stdlib::ifactor(vsubmesh+1);
//    delete vsubdivs[1];
//    vsubdivs := stdlib::ifactor(vmesh).vsubdivs;
//    delete vsubdivs[1];
    usubdivs := stdlib::ifactor(umesh);
    delete usubdivs[1];
    vsubdivs := stdlib::ifactor(vmesh);
    delete vsubdivs[1];
    
    dom::doPlot(out, ineqs, TRUE,
                u, float(umin), float(umax), usubdivs,
                v, float(vmin), float(vmax), vsubdivs,
                attributes);
    
    [umin..umax, vmin..vmax];
  end_proc:
