//      

/* -----------------------------------------------------------
    Line2d -- The graphical primitive for 2D lines

    Syntax:
    Line2d(From, To<, op1, op2, ...>)

    From, To              : lists of 2 expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::Line2d([1, 2], [4, 5])

    >> plot::Line2d(matrix([[1,4],[2, 5]]))

    >> plot::Line2d([1, 2], [4, 5], LineStyle = Dashed)

    >> plot::Line2d(matrix([[1,4],[2, 5]]), LineStyle = Dashed)
----------------------------------------------------------------*/ 

plot::createPlotDomain("Line2d",
                       "graphical primitive for 2D lines"):

//-----------------------------------------------------------------------------
plot::Line2d::styleSheet:= table(
      FromX  = 0,
      FromY  = 0,
      ToX    = 1,
      ToY    = 0
):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::Line2d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() and nops(other) > 0 then
      if not testtype(other[1],
                      Type::ListOf(Type::Arithmetical, 2, 2)) and
        not (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
        error("expecting a list of 2 expressions as 1st argument")
      end_if;
      
      if nops(other) > 1 and not testtype(other[2],
                      Type::ListOf(Type::Arithmetical, 2, 2)) and
        not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
        error("expecting a list of 2 expressions as 2nd argument")
      end_if;

      if nops(other) > 2 then
       error("unexpected argument: ".expr2text(other[3]));
      end_if;
    end_if;
    
    if nops(other) > 0 then
      object::From   := other[1];
      if nops(other) > 1 then
        object::To     := other[2];
      end_if;
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Line2d::print :=
  obj -> hold(plot::Line2d)(obj::From, obj::To):

plot::Line2d::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writeLine2d(attrib, table(), float(attrib[FromX]), float(attrib[FromY]),
      float(attrib[ToX]), float(attrib[ToY]));
  end_proc:
