//      

/* -----------------------------------------------------------
    Line3d -- The graphical primitive for 3D lines

    Syntax:
    Line3d(From, To<, op1, op2, ...>)

    From, To              : lists of 3 expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::Line3d([1, 2, 3], [4, 5, 6])

    >> plot::Line3d(matrix([[1,4],[2, 5],[3,6]]))

    >> plot::Line3d([1, 2, 3], [4, 5, 6], LineStyle = Dashed)

    >> plot::Line3d(matrix([[1,4],[2, 5],[3,6]]), LineStyle = Dashed)
----------------------------------------------------------------*/ 

plot::createPlotDomain("Line3d",
                       "graphical primitive for 3D lines"):

//-----------------------------------------------------------------------------
plot::Line3d::styleSheet:= table(
      FromX  = 0,
      FromY  = 0,
      FromZ  = 0,
      ToX    = 1,
      ToY    = 0,
      ToZ    = 0
):
// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::Line3d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() and nops(other) > 0 then
      if not testtype(other[1],
                      Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
        error("expecting a list of 3 expressions as 1st argument")
      end_if;
      
      if nops(other) > 1 and not testtype(other[2],
                      Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
        error("expecting a list of 3 expressions as 2nd argument")
      end_if;

      if nops(other) > 2 then
       error("unexpected argument: ".expr2text(other[3]));
      end_if;
    end_if;
    
    if nops(other) > 0 then
      object::From:= other[1];
      if nops(other) > 1 then
        object::To  := other[2];
      end_if;
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Line3d::print :=
  obj -> hold(plot::Line3d)(obj::From, obj::To):

plot::Line3d::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writeLine3d(attrib, table(), float(attrib[FromX]), float(attrib[FromY]), float(attrib[FromZ]),
      float(attrib[ToX]), float(attrib[ToY]), float(attrib[ToZ]));
  end_proc:
