//      

/* -----------------------------------------------------------
    PointList2d -- an opaque list of 2D points

    Syntax:
    PointList2d(f, var=a..b, <, op1, op2, ...>)

    f, a, b               : arithmetical expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::PointList2d([[1, 2], [2, 3]])

    >> plot::PointList2d([[1, 2, [0.5, 0.5, 0.5]], [2, 3, [1.0, 0.0, 0.1]]],
                         PointStyle = XCrosses)
----------------------------------------------------------------*/ 

plot::createPlotDomain("PointList2d",
                       "an opaque list of 2D points",
                       2,  // Dimension
   [Points2d, PointStyle, PointSize, PointColor, AntiAliased, Color]):

//-------------------------------------------
plot::PointList2d::new :=
  proc()
    local object, other;
  begin
    object := dom::checkArgs([], args());
    
    other := object::other;
  
    if nops(other) = 1 then
      // object::Points2d := other[1];
      dom::changeNotifier(object, "Points2d" = other[1]);
    elif nops(other) <> 0 then
      error("unexpected argument: ".expr2text(other[2]));
    end_if;

    dom::checkObject(object);
end_proc:
//-------------------------------------------
plot::PointList2d::changeNotifier :=
  proc(object, eq)
    local slotName, newval, l, i, j;
  begin
    [slotName, newval] := [op(eq)];
    case slotName
      of "Points2d" do
        l := newval;
        if l::dom::hasProp(Cat::Matrix) = TRUE then
           l:= expr(l);
        end_if;
        if domtype(l) = DOM_ARRAY then
           if op(l, [0, 1]) <> 2 then 
              error("expecting an array/matrix with 2 columns");
           end_if;
           if op(l, [0, 3, 2]) = op(l, [0, 3, 1]) then
              error("expecting an array/matrix with 2 columns");
           end_if;
           l:=[ [l[i,j] $ j = op(l, [0,3,1])..op(l, [0,3,1]) + 1]
                        $ i = op(l, [0,2,1])..op(l, [0,2,2])];
        end_if;
        dom::extslot(object, "Points2d", l);

        return(FALSE); // we've done all there is to do
        break;
    end_case;
    return(TRUE);
end_proc:

//-------------------------------------------
plot::PointList2d::print :=
  obj -> if nops(obj::Points2d) < plot::pointsInObjectInspector() then
           hold(plot::PointList2d)(obj::Points2d,
                                   dom::printAttributes(obj, {Points2d})):
         else
           hold(plot::PointList2d)([hold(`...`)],
                                   dom::printAttributes(obj, {Points2d})):
         end_if:
//-------------------------------------------
plot::PointList2d::doPlotStatic:=
  proc(out, object, attributes, inherited)
  begin
    out::writePoints2d(attributes, table("PointsVisible"=TRUE), float(attributes[Points2d]));
  end_proc:
