// 

/*
 
 plot::Sequence -- functions and 2D curves defined over integers
 
 plot::Sequence((-1)^n/n, n=1..10)
 
 plot::Sequence((-1)^n/n, n=1..nmax, nmax=1..10)
 
 plot::Sequence(sin(PI*n/10), cos(PI*n/10), n=0..nmax, nmax=0..20)
 
 */
 
plot::createPlotDomain("Sequence",
		       "graphical primitive for sequences",
		       2,
		       [XFunction, YFunction, UName, UMin, UMax, URange,
			PointsVisible, Color, PointSize, PointStyle,
			LinesVisible, LineColor, LineColor2, LineColorType,
			LineColorFunction, LineWidth, LineStyle, AntiAliased]):
			
plot::Sequence::setPrimaryColor(LineColor):

plot::Sequence::styleSheet := table(LinesVisible = FALSE,
                                    PointSize = 2,
				    PointsVisible = TRUE):
			
plot::Sequence::new :=
proc()
  local object, other;
begin
  object := dom::checkArgs(["U"], args());
  
  other := object::other;
  
  case nops(other)
    of 0 do /* nothing */ break;
    of 1 do
      object::XFunction := x -> x;
      object::YFunction := other[1];
      break;
    of 2 do
      object::XFunction := other[1];
      object::YFunction := other[2];
      break;
    otherwise
      error("unexpected argument: ").expr2text(other[3]);
  end_case;
  
  dom::checkObject(object);
end_proc:

plot::Sequence::print :=
proc(obj)
begin
  if obj::XFunction = (x->x) then
    hold(plot::Sequence)(obj::YFunction, obj::UName=obj::URange);
  else
    hold(plot::Sequence)(obj::XFunction, obj::YFunction, obj::UName=obj::URange);
  end_if;
end_proc:

plot::Sequence::doPlotStatic :=
proc(out, obj, attributes, inheritedAttributes)
  local nmin, nmax, n, x, y,
	linecolorfunction,
        points;
begin
  x := float@(attributes[XFunction]);
  y := float@(attributes[YFunction]);
  nmin := round(attributes[UMin]);
  nmax := round(attributes[UMax]);

  if contains(attributes, LineColorFunction) then
    linecolorfunction := attributes[LineColorFunction];
  else
    linecolorfunction := null();
  end_if;
  
  points := [];
  for n from nmin to nmax do
    traperror((points:=points.[[x(n), y(n)]]));
  end_for;
  if nops(points)=0 then return(null()); end_if;
  return(out::writePoly2d(attributes, table("Filled"=FALSE), points, linecolorfunction));
end_proc:
	
