//      

/* -----------------------------------------------------------
    Sphere -- The graphical primitive for 3D spheres

    Syntax:
    Sphere(radius<, center><, op1, op2, ...>)

    radius                : expression
    center                : list of 3 expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::Sphere(2)

    >> plot::Sphere(2, [1, 2, 3])
----------------------------------------------------------------*/ 

plot::createPlotDomain("Sphere",
                       "graphical primitive for 3D spheres"):

//-----------------------------------------------------------------------------
plot::Sphere::styleSheet := table(
      //LinesVisible = TRUE,
      //LineColor    = RGB::Black,
      FillColor = RGB::LightBlue,
      Radius       = 1,
      CenterX      = 0,
      CenterY      = 0,
      CenterZ      = 0
):
//------------------------------------------------------------------------
// Hints for parents:
plot::Sphere::hints := {
      Scaling = Constrained
}:
//------------------------------------------------------------------------

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
//-----------------------------------------------------------------------------
plot::Sphere::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() and nops(other) > 0 then
      if nops(other) > 2 then
        error("unexpected argument: ".expr2text(other[3]))
      end_if;

      if not testtype(other[1], Type::Arithmetical) then
        error("1st argument: expecting an expression (the radius)")
      end_if;

      if nops(other) = 2 and
        not testtype(other[2],
                     Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
        error("2nd argument: expecting a list of 3 expressions (the center)")
      end_if;
      // allow matrix input
      if nops(other) = 2 and (other[2])::dom::hasProp(Cat::Matrix) = TRUE then
         other[2]:= [op(other[2])];
      end_if;
    end_if;

    if nops(other) > 0 then
      object::Radius := other[1];
      if nops(other) = 2 then
        object::Center := other[2];
      end_if;
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Sphere::print :=
  obj -> hold(plot::Sphere)(obj::Radius, obj::Center):

plot::Sphere::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writeSphere(attrib, table(), float(attrib[CenterX]),
                              float(attrib[CenterY]),
                              float(attrib[CenterZ]),
                              float(attrib[Radius]));
  end_proc:
