// 

/*
 plot::Sum(ex, n=a..b)
 plot::Sum(sum(ex, n=a..b))
 
 plot the function x -> sum(ex, n=a..floor(x)) for x from a to b+1-epsilon.
 
 Examples:
 
 plot(plot::Sum(sin(j^2)/j, j=1..500))

 plot(plot::Sum(1/j, j=1..50,
                PointsVisible = TRUE,
                LinesVisible = FALSE,
                PointColor = RGB::Black))

 plot(plot::Sum(sum(1/i^2, i=1..10)))

 plot(plot::Sum(sum(sin(a*i)/i, i = 1..10), a = 0..2*PI))
 
 */
 
plot::createPlotDomain("Sum",
		       "graphical primitive for symbolic sums",
		       2,
		       [Function, XName, XMin, XMax, XRange,
			Filled, FillColor, FillPattern,
			PointColor, Color,
			LineColor, LineColor2, LineColorType,
			LineColorFunction,
			LineWidth, LineStyle, AntiAliased,
			LineColorDirection, LineColorDirectionX,
			LineColorDirectionY,
			LinesVisible, PointsVisible]):
			
plot::Sum::styleSheet := table(PointsVisible = FALSE,
                               AntiAliased = FALSE,
			       Filled = FALSE,
			       FillPattern = Solid):

plot::Sum::setPrimaryColor(LineColor):

// to accept symbolic sum-calls, this constructor must use
// option hold.
plot::Sum::new :=
proc()
  local object, other, arg_list, a;
  option hold;
begin
  arg_list := [];
  for a in [args()] do
    a := context(hold(hold)(a));
    if domtype(a) = DOM_VAR then
      a := context(a);
    end_if;
    if domtype(a) = DOM_EXPR and
       op(a, 0) = hold(sum) then
      if type(op(a, 2)) <> "_equal" then
	error("sums must be definite!");
      end_if;
      a := op(a);
    else
      a := context(a);
    end_if;
    arg_list := arg_list.[a];
  end_for;
  
  object := dom::checkArgs(["X"], op(arg_list));
  other := object::other;
  
  if nops(other) > 0 then
    if nops(other) > 1 then
      error("unexpected argument ".expr2text(other[2]));
    end_if;
    object::Function := other[1];
  end_if;
  
  dom::checkObject(object);
end_proc:

plot::Sum::print := s -> hold(plot::Sum)(s::Function, s::XName=s::XRange):

plot::Sum::doPlotStatic :=
proc(out, s, attributes, inheritedAttributes)
  local partsum, i, a, b, ex, x, miny, maxy;
begin
  ex := attributes[Function];
  x  := attributes[XName];
  a  := attributes[XMin];
  b  := attributes[XMax];
  
  partsum := 0.0;
  
  miny := RD_INF;
  maxy := RD_NINF;
  
  for i from a to b do
    partsum := numeric::complexRound(partsum + float(ex(i)));
    if domtype(partsum) = DOM_FLOAT then
      miny := min(miny, partsum);
      maxy := max(maxy, partsum);
      out::writePoly2d(attributes, table("PointsVisible" = FALSE), [[i, partsum], [i+1, partsum]]);
      out::writePoint2d(attributes, table(), i, partsum);
      // rectangles to be filled
      out::writePoly2d(attributes, table("PointsVisible" = FALSE, "LinesVisible" = FALSE),
        [[i,0],[i, partsum], [i+1, partsum], [i+1, 0]]);
    end_if;
  end_for;
  
  if {miny, maxy} intersect {RD_NINF, RD_INF} = {} then
    [a..b+1, miny..maxy];
  else
    null();
  end_if;
end_proc:
