//      

/* -----------------------------------------------------------
    Text2d -- The graphical primitive for animated 2D texts

    Syntax:
    Text2d(text, position<, op1, op2, ...>)

    text                  : a text string
    position              : list of 2 expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:

    >> plot::Text2d("a text", [sin(a), cos(a)], a = 0..2*PI)

    >> plot::Text2d(, [sin(a), cos(a)], a = 0..2*PI)

    >> plot::Text2d(, [0, 0], TextRotation=a, a = 0..360)
----------------------------------------------------------------*/ 

plot::createPlotDomain("Text2d",
                       "graphical primitive for 2D texts",
2,
[[Text, ["Mandatory", NIL],
         ["Definition", "Expr", plot::elementOptTextExpr, "Text expression", FALSE]], 
 Position, PositionX, PositionY, HorizontalAlignment, VerticalAlignment, TextRotation, TextFont]):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::Text2d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() and nops(other) > 0 then
      if nops(other) > 2 then
        error("unexpected argument: ".expr2text(other[3]))
      end_if;

      if nops(other) < 2 then
        error("expecting a string and a list")
      end_if;

      if not testtype(other[2],
                      Type::ListOf(Type::Arithmetical, 2, 2)) and
        not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
        error("expecting a list of 2 expressions as 2nd argument")
      end_if;
    end_if;
    
    if nops(other) > 0 then
      object::Text  := other[1];
      if nops(other) > 1 then
        object::Position := other[2];
      end_if;
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Text2d::print :=
  obj -> hold(plot::Text2d)(obj::Text, obj::Position):

plot::Text2d::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writeText2d(attrib, table(), float(attrib[PositionX]), float(attrib[PositionY]), attrib[Text](), float(attrib[TextRotation]));
  end_proc:
