//      

/* -----------------------------------------------------------
    Text3d -- The graphical primitive for animated 3D texts

    Syntax:
    Text3d(text, position<, op1, op2, ...>)

    text                  : a text string
    position              : list of 2 expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:

    >> plot::Text3d("a text", [1, sin(a), cos(a)], a = 0..2*PI)

    >> plot::Text3d(a -> "a = ".expr2text(a), [1, sin(a), cos(a)], a = 0..2*PI)

    >> plot::Text3d(a -> "a = ".expr2text(a), [0, 0, 0], TextRotation=a, a = 0..360)
----------------------------------------------------------------*/ 

plot::createPlotDomain("Text3d",
                       "graphical primitive for 3D texts",
3,
[[Text, ["Mandatory", NIL],
         ["Definition", "Expr", plot::elementOptTextExpr, "Text expression", FALSE]], 
 Position, PositionX, PositionY, PositionZ, HorizontalAlignment, VerticalAlignment, TextOrientation, TextFont, Billboarding]):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::Text3d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() and nops(other) > 0 then
      if nops(other) > 2 then
        error("unexpected argument: ".expr2text(other[3]))
      end_if;

      if nops(other) < 2 then
        error("expecting a string and a list")
      end_if;

      if not testtype(other[2],
                      Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
        error("expecting a list of 3 expressions as 2nd argument")
      end_if;
    end_if;
    
    if nops(other) > 0 then
      object::Text  := other[1];
      if nops(other) > 1 then
        object::Position := other[2];
      end_if;
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Text3d::print :=
  obj -> hold(plot::Text3d)(obj::Text, obj::Position):

plot::Text3d::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writeText3d(attrib, table(), float(attrib[PositionX]), float(attrib[PositionY]), float(attrib[PositionZ]),
      float(attrib[TextOrientation][1]), float(attrib[TextOrientation][2]), float(attrib[TextOrientation][3]),
      float(attrib[TextOrientation][4]), float(attrib[TextOrientation][5]), float(attrib[TextOrientation][6]),
      attrib[Text]());
  end_proc:
