// 

// plot::writeGridContours: plot -- plot contour lines
// for an regular mesh

plot::writeGridContours :=
proc(data, umesh, vmesh,
     ops, contdir, contours,
     linecolorfunction, _min, _max)
  local writeCLine, linearZero,
	c, i, j, ij,
	p1, p2, p3, p4,
	p12, p24, p13, p34,
	t, interpol;
begin
  contours := float(contours);
  if contours = [] then return(); end_if;
  
  writeCLine :=
  proc(p1, p2)
  begin
    plot::MuPlotML::prP3(op(p1, ops), // the point
			 linecolorfunction(p1));
    plot::MuPlotML::prP3(op(p2, ops), // the point
			 linecolorfunction(p2));
  end_proc;
  
  // linear interpolation over all components
  interpol := (a,b)->t*a+(1-t)*b;
  linearZero :=
  proc(p1, p2)
    local z1, z2;
  begin
    z1 := op(p1, contdir);
    z2 := op(p2, contdir);
    if iszero(z1-z2) then
      p1;
    else
      t := (c-z2)/(z1-z2);
      zip(p1, p2, interpol);
    end_if;
  end_proc;
  
  if contours[1] = hold(Automatic) then
    if nops(contours) > 1 and
       domtype(float(contours[2])) = DOM_FLOAT then
      contours := float(contours[2]);
    else
      contours := 15;
    end_if;
    if contours < 2 then contours := 2; end_if;
    _max := _max - frac(contours)/floor(contours) * (_max - _min);
    contours := floor(contours);
    contours := [_min + i*(_max-_min)/(contours-1)
		 $ i = 0..contours-1];
  end_if; // Automatic
  
  plot::MuPlotML::beginElem("Lines3d",
			    "Type"="Lines",
			    "PointsVisible"=FALSE);
  
  for c in contours do
    for i from 1 to vmesh-1 do
      for j from 1 to umesh-1 do
	ij := (i-1)*umesh+j;
	p1 := data[ij];
	p2 := data[ij+1];
	p3 := data[ij+umesh];
	p4 := data[ij+umesh+1];
	case [specfunc::sign(c-op(p1, contdir)),
	      specfunc::sign(c-op(p2, contdir)),
	      specfunc::sign(c-op(p3, contdir)),
	      specfunc::sign(c-op(p4, contdir))]
	// we never draw lines from p3 to p4 or from p2 to p4,
	// to avoid duplicates.  Those at the left and
	// the upper corner will be handled after the loop.
	  of [ 0, 0, 0, 0] do
	    writeCLine(p1, p2);
	    writeCLine(p2, p3);
	    writeCLine(p4, p1);
	    writeCLine(p1, p3); break;
	  of [ 0, 0, 0, 1] do
	  of [ 0, 0, 0,-1] do
	    writeCLine(p1, p2);
	    writeCLine(p2, p3);
	    writeCLine(p1, p3); break;
	  of [ 0, 0, 1, 0] do
	  of [ 0, 0,-1, 0] do
	    writeCLine(p1, p2);
	    writeCLine(p4, p1); break;
	  of [ 0, 1, 0, 0] do
	  of [ 0,-1, 0, 0] do
	    writeCLine(p4, p1);
	    writeCLine(p1, p3); break;
	  of [ 1, 0, 0, 0] do
	  of [-1, 0, 0, 0] do writeCLine(p2, p3); break;
	  of [ 0, 0, 1, 1] do
	  of [ 0, 0,-1,-1] do writeCLine(p1, p2); break;
	  of [ 0, 1, 0, 1] do
	  of [ 0,-1, 0,-1] do writeCLine(p1, p3); break;
	  of [ 1, 0, 0, 1] do
	  of [-1, 0, 0, 1] do
	  of [ 1, 0, 0,-1] do
	  of [-1, 0, 0,-1] do writeCLine(p2, p3); break;
	  of [ 0, 1, 1, 0] do
	  of [ 0,-1, 1, 0] do
	  of [ 0, 1,-1, 0] do
	  of [ 0,-1,-1, 0] do writeCLine(p1, p4); break;
	    
	  of [ 1, 1, 1,-1] do
	  of [-1,-1,-1, 1] do
	    writeCLine(linearZero(p2,p4), linearZero(p3,p4)); break;
	    
	  of [ 0, 1, 1,-1] do
	  of [ 0,-1,-1, 1] do
	    p24 := linearZero(p2, p4);
	    p34 := linearZero(p3, p4);
	    writeCLine(p1, p24);
	    writeCLine(p1, p34);
	    writeCLine(p24, p34);
	    break;
	    
	  of [-1, 1, 1, 1] do
	  of [ 1,-1,-1,-1] do
	    writeCLine(linearZero(p1, p3), linearZero(p1, p2)); break;
	    
	  of [-1, 1, 1, 0] do
	  of [ 1,-1,-1, 0] do
	    p12 := linearZero(p1, p2);
	    p13 := linearZero(p1, p3);
	    writeCLine(p12, p4);
	    writeCLine(p13, p4);
	    writeCLine(p12, p13);
	    break;
	    
	  of [-1, 1, 1,-1] do
	    p12 := linearZero(p1, p2);
	    p24 := linearZero(p2, p4);
	    p13 := linearZero(p1, p3);
	    p34 := linearZero(p3, p4);
	    writeCLine(p12, p24); writeCLine(p24, p34);
	    writeCLine(p34, p13); writeCLine(p13, p12);
	    writeCLine(p12, p34); writeCLine(p24, p13);
	    break;
	    
	  of [ 1, 0, 1,-1] do
	  of [-1, 0,-1, 1] do
	    writeCLine(p2, linearZero(p3, p4)); break;
	    
	  of [ 0, 0, 1,-1] do
	  of [ 0, 0,-1, 1] do
	    p34 := linearZero(p3, p4);
	    writeCLine(p2, p34);
	    writeCLine(p1, p34);
	    writeCLine(p1, p2);
	    break;
	    
	  of [-1, 0, 1, 1] do
	  of [ 1, 0,-1,-1] do
	    writeCLine(linearZero(p1, p3), p2); break;
	    
	  of [-1, 0, 1, 0] do
	  of [ 1, 0,-1, 0] do
	    p13 := linearZero(p1, p3);
	    writeCLine(p13, p4);
	    writeCLine(p13, p2);
	    break;
	    
	  of [-1, 0, 1,-1] do
	  of [ 1, 0,-1, 1] do
	    p13 := linearZero(p1, p3);
	    p34 := linearZero(p3, p4);
	    writeCLine(p2, p34);
	    writeCLine(p2, p13);
	    writeCLine(p13, p34);
	    break;
	    
	  of [ 1,-1, 1, 1] do
	  of [-1, 1,-1,-1] do
	    writeCLine(linearZero(p1, p2), linearZero(p2, p4));
	    break;
	    
	  of [ 1,-1, 1, 0] do
	  of [-1, 1,-1, 0] do
	    writeCLine(linearZero(p1, p2), p4); break;
	    
	  of [ 1,-1, 1,-1] do
	  of [-1, 1,-1, 1] do
	    writeCLine(linearZero(p1, p2), linearZero(p3, p4));
	    break;
	    
	  of [ 0,-1, 1, 1] do
	  of [ 0, 1,-1,-1] do
	    writeCLine(p1, linearZero(p2, p4)); break;
	    
	  of [ 0,-1, 1,-1] do
	  of [ 0, 1,-1, 1] do
	    writeCLine(p1, linearZero(p3, p4)); break;
	    
	  of [-1,-1, 1, 1] do
	  of [ 1, 1,-1,-1] do
	    writeCLine(linearZero(p1, p3), linearZero(p2, p4)); break;
	    
	  of [-1,-1, 1, 0] do
	  of [ 1, 1,-1, 0] do
	    writeCLine(linearZero(p1, p3), p4); break;
	    
	  of [-1,-1, 1,-1] do
	  of [ 1, 1,-1, 1] do
	    writeCLine(linearZero(p1, p3), linearZero(p3, p4)); break;
	    
	  of [ 1, 1, 0,-1] do
	  of [-1,-1, 0, 1] do
	    writeCLine(linearZero(p2, p4), p3); break;
	    
	  of [ 0, 1, 0,-1] do
	  of [ 0,-1, 0, 1] do
	    p24 := linearZero(p2, p4);
	    writeCLine(p1, p3);
	    writeCLine(p1, p24);
	    writeCLine(p3, p24);
	    break;
	    
	  of [-1, 1, 0, 1] do
	  of [ 1,-1, 0,-1] do
	    writeCLine(linearZero(p1, p2), p3); break;
	    
	  of [-1, 1, 0, 0] do
	  of [ 1,-1, 0, 0] do
	    p12 := linearZero(p1, p2);
	    writeCLine(p3, p12);
	    writeCLine(p4, p12);
	    break;
	    
	  of [-1, 1, 0,-1] do
	  of [ 1,-1, 0, 1] do
	    p12 := linearZero(p1, p2);
	    p24 := linearZero(p2, p4);
	    writeCLine(p3, p12);
	    writeCLine(p3, p24);
	    writeCLine(p12, p24);
	    break;
	  
	end_case;
      end_for; // j
      // "right" border
      if iszero(c-op(p2, contdir)) and
	 iszero(c-op(p4, contdir)) then
	writeCLine(p2, p4);
      end_if;
    end_for; // i
    // "upper" border
    for j from 1 to umesh-1 do
      p1 := data[umesh*(vmesh-1)+j];
      p2 := data[umesh*(vmesh-1)+j+1];
      if iszero(c-op(p1, contdir)) and
	 iszero(c-op(p2, contdir)) then
	writeCLine(p1, p2);
      end_if;
    end_for;
  end_for; // c
  
  plot::MuPlotML::endElem("Lines3d");
  
end_proc:

