//       


faclib::eqdegr:=
proc(f,d,flag=2, seed = 1)
  save SEED;
  local F,size,x,xqk,k,bbeta,betai,ggamma,h1,h2,h3,pol,m,dim,l,j;
// f must be a product of distinct irreducible factors of degree d 
// returns one factor if flag=0 
// returns one irreducible factor if flag=1 
// returns a complete factorization otherwise (e.g. if flag is not given) 

begin
  SEED:= seed; // to ensure deterministic behavior
  userinfo(1,"Equal-degree factorization for degree ".expr2text(d));
  F:=op(f,3);
  if degree(f)=0 then
    userinfo(2,"Polynomial is constant");
    if flag=0 or flag=1 then
      return();   // null() 
    else
      return ([]);
    end_if;
  end_if;
  if degree(f)=d then
    userinfo(3,"Irreducible factor found:",f);
    if flag=0 or flag=1 then
      return(f);
    else
      return ([f]);
    end_if;
  end_if;
  if domtype(F)=DOM_DOMAIN then
    if F::hasProp(Dom::IntegerMod) or F::hasProp(Dom::GaloisField) then
      size:=F::size;
    else
      error("Illegal arguments");
    end_if;
  elif domtype(F)=DOM_EXPR and has(F,IntMod) then
    size:=op(F);
  else
    error("Illegal arguments");
  end_if;

  x:=op(f,[2,1]);
  pol:=poly(x,[x],F);
  dim:=degree(f)-1;
  m:=[faclib::powermod_poly(pol,size,f)];
  for l from 2 to dim do
    m:=append(m, divide(m[l-1]*m[1],f,hold(Rem)));
  end_for;


  xqk:=polylib::randpoly([x],F,hold(Degree)=degree(f), hold(Terms)=infinity);
  bbeta:=xqk;
  for k from 1 to d-1 do
    xqk:=poly(coeff(xqk,0),[x],F)+
          _plus(multcoeffs(m[j],coeff(xqk,j))$j=1..dim);

	// same effect as  xqk:=faclib::powermod_poly(xqk,size,f);   
    bbeta:=divide(bbeta*xqk, f, Rem);
  end_for;
  if irem(size,2)=1 then
    ggamma:=faclib::powermod_poly(bbeta,(size^d-1)/2,f);
    h1:=gcd(ggamma,f);
    if degree(h1)>0 and degree(h1) < degree(f) then
      userinfo(3,"Factor found:",h1);
      if flag=0 then return(h1); end_if;
    end_if;
    h2:=gcd(ggamma-poly(1,[x],F),f);
    if degree(h2)>0 and degree(h2) < degree(f) then
      userinfo(3,"Factor found:",h2);
      if flag=0 then return(h2); end_if;
    end_if;
    h3:=divide(f,h1*h2,hold(Exact));
    l:=select([h1,h2,h3],proc() begin degree(args(1))>0 end_proc );
    if nops(l)=1 then
      userinfo(2,"Split did not succeed");
      // try again 
      return(faclib::eqdegr(f,d,flag, seed+1));
    else
      userinfo(2,"Split succeeded");
		userinfo(2,"Continuing with polynomials of degrees",
				op(map(l,degree)));
    end_if;
    if flag=1 then
      return(faclib::eqdegr
             (op(select(l, proc()
                           begin
                             degree(args(1))=min(op(map(l,degree)))
                           end_proc
                        ),1),d,1));
		/* Continue with the polynomial of minimal degree;
		  if there are several, take the first of them */
    end_if;
    return(_concat(op(map(l,proc()
                           begin
                             faclib::eqdegr(args(1),d)
                           end_proc ))));
  else
    // characteristic 2
    // see, for example, von zur Gathen + Gerhard, exercise 14.16
    betai:= bbeta;
    ggamma:= bbeta;
    for k from 1 to round(ln(size)/ln(2))-1 do
      betai:=divide(betai*betai,f,hold(Rem));
      // betai = bbeta^(2^k) mod f
      ggamma:=ggamma+betai;
      // ggamma = bbeta + bbeta^2 + bbeta^4 + ... + bbeta^(2^k)
      // (the k+1st trace polynomial)
    end_for;
    h1:=gcd(ggamma,f);
    if degree(h1)>0 and degree(h1)< degree(f) then
      userinfo(3,"Factor found:",h1);
      if flag=0 then return(h1); end_if;
      h2:=divide(f,h1,hold(Exact));
      l:=[h1,h2];
      userinfo(2,"Split succeeded");
      userinfo(2,"Continuing with polynomials of degrees",
               op(map(l,degree)));
      if flag=1 then
        if degree(h1)<degree(h2) then
          return(faclib::eqdegr(h1,d,1));
        else
          return(faclib::eqdegr(h2,d,1));
        end_if;
      else
        return(faclib::eqdegr(h1,d).faclib::eqdegr(h2,d));
      end_if;
    else
      userinfo(2,"Split did not succeed");
      // try again 
      return(faclib::eqdegr(f,d,flag, seed+1));
    end_if;
	 
  end_if;

end_proc:
