//          

// factorgf - factorization of univariate polynomials over finite fields 

faclib::factorgf :=
proc(p: DOM_POLY)
// p - polynomial over Dom::GaloisField, Dom::IntegerMod or IntMod 
//                  or Dom::AlgebraicExtension, if it is a finite field 
// arguments are not tested  
local fs,fas,fac,F,i,j,k,e,n,m;

begin
  F:=op(p,3);
  if domtype(F)=DOM_EXPR then
    assert(op(F, 0) = IntMod);
    n:=op(F);
    m:=1;
  elif F::hasProp(Dom::GaloisField) then
    n:=F::characteristic;
    m:=F::deg;
  elif F::hasProp(Dom::IntegerMod) then
    n:=F::characteristic;
    m:=1;
  else
    error("Unknown field");
  end_if;


  fas:=[coeff(p,degree(p))];
  p:=multcoeffs(p,1/op(fas));
  fs:=faclib::sqrfree_ffield(p,n,m);
  for i from 1 to nops(fs) step 2 do
    fac:=faclib::distdegr(op(fs,i));
    for j from 1 to nops(fac) do
      if degree(op(fac,j)) > 0 then
        if degree(op(fac,j))=j then
          userinfo(20, "One factor of degree ".expr2text(j));
          fas:=fas.[op(fac,j),op(fs,i+1)];
        else
          userinfo(20, "Several factors of degree ".expr2text(j));
          userinfo(20, "Using equal-degree factorization");
          e:=faclib::eqdegr(op(fac,j),j);
          fas:=fas.[(op(e,k),op(fs,i+1)) $ k=1..nops(e)];
        end_if;
      end_if;
    end_for;
  end_for;
  fas;
end_proc:
	
	
