//    

// stefanw, 29.1. 1998 

/*++
	faclib::fracfact(f)   

	f - polynomial over Dom::Fraction 

  	factors a polynomial over Dom::Fraction(R), if
	factorization over R is possible.

++*/

faclib::fracfact:=proc(ff)
local F,R,cont, factorization,i,f;

begin
F:=op(ff,3);
R:=F::coeffRing;
cont:=lcm(map(coeff(ff), denom));
f:=multcoeffs(ff, cont);
factorization:=factor(subsop(f,3=R));
factorization:=Factored::convert_to(factorization,DOM_LIST);
factorization[1]:=F(factorization[1])*F(hold(_power)(cont,-1));
for i from 2 to nops(factorization) step 2 do
	factorization[i]:=poly(factorization[i],op(f,2..3))
end_for;
factorization
end_proc:
