/*
faclib::homo -- for square free multivariate polynomial, check if it is a
                homogeneous polynomial, if so, then simplify it to (n-1)
                variate polynomial and factor it, at last restore the nth
                variable.  The basic idea comes from R. Zippel, Effective
                Polynomial Computation, page 332, Kluwer Academic
                Publishers,1993.  Output is a list of factors in polynomial
                form.

faclib::homo(d,x,a)
d - degree of input polynomial
x - main variable
a - input square free multivariate polynomial
*/

faclib::homo:=
proc(d,x,a)
  local b, fs, i, j, nv, tv;
begin
  for i from nterms(a) downto 1 do
    if degree(nthterm(a,i))<>d then
      userinfo(5, "Polynomial is not homogenous");
      return(faclib::mfactor(a));
    end_if;
  end_for;
  userinfo(5, "Polynomial is homogenous of degree ".expr2text(d));
  tv:=op(a,[2,nops(op(a,2))]);
  b:=evalp(a,tv=1);
  userinfo(10, "Evaluating at ".expr2text(tv)."= 1 gives ".
           expr2text(b));
  if (nv:=nops(op(b,2)))=1 then
    fs:=faclib::ufactor(multcoeffs(b,sign(lcoeff(b))),x);
  elif degree(b,x)=2 and nv=2 then
    fs:=faclib::pdeg2(b,x);
  else
    fs:=faclib::mfactor(b);
  end_if;
  if nops(fs)=1 then
    return([a]);
  else
    return([poly(_plus(_power(tv,degree(fs[i])-
                              degree(nthterm(fs[i],j)))*
                       expr(nthmonomial(fs[i],j))\
                       $j=1..nterms(fs[i])))$i=1..nops(fs)]);
  end_if;
end_proc:
