//   #

/*
faclib::mfactor -- return the factorization of multivariate polynomial in
                   Z[x1..xn], output is a list of factors in polynomial form.

faclib::mfactor(p)
p - a primitive square free multivariate polynomial in Z[x1..xn]

faclib::mfactor choose a main variable x1, factorize the lcoeff of p in Z[x1] at
first, then random choose a suitable set of value x2..xn, factorize univariate p in Z[x1,x2..xn], at last lift the factors from univariate to multivariate 
*/ 

faclib::mfactor:=
proc(pp)
  local bn, d, f, fb, fm, fs, i, lcont, lfs, lgs, ll, minfs, n0, nf,
  nl, p0, pl, x0, xl,p,l;
  save SEED;
begin
  SEED:= 1; // to ensure reproducible behavior
  p:=pp; // to avoid warnings 
  userinfo(2,"mfactor called with argument ".expr2text(p));
  // choose the main variable 
  xl:=[faclib::set_x(p)];
  p:=poly(p,xl);
  x0:=xl[1];
  bn:=map([xl[i]$i=2..nops(xl)], _equal, 0);
  userinfo(2,"Trying zero evaluation point");
  p0:=poly(p,[x0]);
  minfs:=degree(p0)+1;
  //  factorize the leading coefficient of p in Z[x1] 
  userinfo(2,"Factoring leading coefficient");
  userinfo(10, "lcoeff is ". expr2text(lcoeff(p0)));
  lcoeff(p0);
  fs:=if degree(%)=0 then
        [%]
      else
        Factored::convert_to(factor(%),DOM_LIST)
      end_if;
  lcont:=op(fs,1);
  nl:=(nops(fs)-1)/2;
  userinfo(2, if nl=0 then
                "Leading coefficient is a unit in Q"
              else  
                "Leading coefficient has ".expr2text(nl)." factors"
              end_if  );
  lfs:=[op(fs,2*i)$i=1..nl];
  lgs:=[op(fs,2*i+1)$i=1..nl];
  sysassign(faclib::Rn, -1);
  sysassign(faclib::Rgb, 3);
  repeat
    minfs:=minfs-1;
    if minfs=1 then
      return([p]);
    end_if;
    nf:=0;
    // random choose a suitable set of evaluation point of x2..xn 
    repeat
      userinfo(10, "Choosing an evaluation point");
      fb:=faclib::set_b(p,bn,lfs,lcont,tcoeff(poly(p,[x0])));
      // factorize the polynomial in univariate case 
      f:=faclib::pfactor(multcoeffs(fb[1],sign(lcoeff(fb[1]))),2);
      f:=[op(f,2*i-1)$i=1..nops(f)/2];
      userinfo(expr2text(nops(f))." univariate factors");
      if (n0:=nops(f))=1 then
        return([p]);
      elif n0<minfs then
        minfs:=n0;
        nf:=1;
        userinfo(4,"Better evaluation point: only ".
                 expr2text(minfs)." modular factors");
      elif n0=minfs then
        nf:=nf+1;
      end_if;
      /* when the number of factors of univariate factorization are 
       the same for two sets of random x2..xn, can try to lift    
       them to multivariate case                                  
       changed to  f i v e  sets, to decrease error probability S.W. */
      
    until nf=5 end_repeat;
    
     // restore the lead coefficient of p in Z[x1]
    
    userinfo(2,"Restoring leading coefficient");
    if (fm:=faclib::mrestore
        (p,[multcoeffs(f[1],sign(lcoeff(fb[1]))),
            op(f,i)$i=2..nops(f)],minfs,lfs,lgs,fb[i]$i=2..4))
      <>FAIL then
     
	// Added 2001-11-14
	// we will try to solve the lifting-problem via a
	// solution to a lineas system. hornp. 
	if (l := faclib::heulift(fm[1],fm[2],fm[3],[FAIL])) <> FAIL then
		// we have to remove the content from the factors that was
		// possibly introduced by mrestore.
		// here we rely on fm[1]/p being a positive integer.
		l := map (l,polylib::primpart);
		return (l);
	end_if;



      /* pl is the prime number in which the lifting done, it must be 
       larger than the bound
       (see page 229-230, Proceedings of the  
        1986 symposium on symbolic and algebraic computations, July  
        21-23, 1986, Waterloo, Ontarro),
       and not divide lcoeff of p  
       in Z[x1,a2..an], and in Zpl p(x1,a2..an) must be square free */
      
      d:=degreevec(fm[1]);
      d:=map(d,proc(xx)
               begin
                 fact(2*xx)/_power(fact(xx),2)
               end_proc);
      pl:=1+trunc(norm(fm[1],2)*
                  float(sqrt(_mult(d[i]$ i=1..nops(d)))));
      ll:=lcont*fb[2]*lcoeff(fb[1]);
      repeat
        pl:=faclib::getprime(ll,pl);
        f:=poly(fb[1],IntMod(pl));
      until type(expr(gcd(f,polylib::Dpoly([1], f))))=DOM_INT end_repeat;
      // diff(f,x0) 
      if (f:=faclib::mhensel(minfs,fm,fb[3],pl,x0))<>FAIL then
        return(f);
        else // mhensel fails
          warning("mhensel fails for ". expr2text(p,fb,fm,pl))
      end_if;
    else // mrestore fails
      warning("mrestore fails for ". expr2text(p,f,minfs,lfs,lgs,fb))
    end_if;
    /* seldom, unlucky case is that the number of factors in  
       univariate case is more than that of multivariate case */
  until minfs=1 end_repeat;
end_proc:


