/*--
faclib::pfs -- return the factors of input polynomial, if it doesn't in variable
               x0, the basic idea is computing the gcd of all coefficients of p
               in Z[x0], but to save the computing time, take sevearl checking
               steps at first.  Output is 1 if the factor doesn't exist,
               otherwise, the factor itself.

faclib::pfs(p, x0)
p - a multivariate polynomial
x0 - the chosen variable
--*/

faclib::pfs:=
proc(p,x0)
  local c, c0, g, i, j, pg, q, X;
begin
  q:=FAIL;
  c0:=[coeff(poly(p,[x0]))];
  X:= {op(op(p,2))};
  if map({op(c0)}, type)={"_plus"} then
    // if _and(bool(type(c0[i])="_plus") $i=1..nops(c0)) then 
    if _intersect(X, indets(c0[i],PolyExpr)$i=1..nops(c0))<>{} then
      c:=sort(c0,proc(a,b)
                 begin
                   bool(degree(a)<degree(b))
                 end_proc);
      g:=expand(c[1]/icontent(c[1])/op(faclib::monomial(poly(c[1])),2));
      for i from 2 to nops(c) do
        if type(g)=DOM_INT then
          return(1);
        elif _intersect(X, indets(g,PolyExpr),
                        indets(c[j],PolyExpr)$j=i..nops(c))={} then
          return(1);
        else
          pg:=poly(g,op(p,2));
          for j from i to nops(c) do
            if divide(poly(c[j],op(p,2)),pg,Exact)=FAIL then
              if degree(poly(pg))=1 then
                return(1);
              else
                q:=1;
                break;
              end_if;
            end_if;
          end_for;
          if q<>1 then
            return(multcoeffs(pg,sign(lcoeff(pg))));
          end_if;
        end_if;
        g:=gcd(g,c[i]/icontent(c[i])/op(faclib::monomial(poly(c[i])),2));
      end_for;
      if type(g)=DOM_INT then
        return(1);
      else
        return(poly(multcoeffs(g,sign(lcoeff(g))),op(p,2)));
      end_if;
    end_if;
  end_if;
  1;
end_proc:
