/*--
faclib::quafree-- return the square-free factorization of p(x) using Yun's
                  algorithm (see Keith O. Geddes, Stephen R. Czapor and George
                  Labahn, Algorithms for computer algebra, page 342, Kluwer
                  Academic Publishers, 1992).  Output is given in form [f1,e1,
                  ...,fn,en], p=f1^e1*..*fn^en.

faclib::quafree(p) 
p - a primitive multivariate polynomial in Z, its factors must have the same
    variables
--*/

faclib::quafree:=proc(p)
local d, dd, dp, g,  i, qfree, sp, w, x, z;
begin
    userinfo(1, "Squarefree factorization (Yun's algorithm) called");
    x:=op(p,[2,1]);
    d:=degree(p,x);
    if nops(op(p,2))>1 then
       // if multivariate polynomial is square free, computing gcd in          
       // univariate case by evaluating x2..xn may be a simpler and faster way 
       sp:=poly(subs(expr(p),[(op(p,[2,i])=i)$i=2..nops(op(p,2))]),[x]);
       if degree(sp)=d then // diff(sp,x) 
          if type(expr(gcd(sp,polylib::Dpoly([1], sp))))=DOM_INT then 
	     userinfo(2,"Found squarefree homomorphic image");
             return([p,1]); 
          end_if;
       end_if;
    end_if; 
    dp:=polylib::Dpoly([1], p); // diff(p,x) 
    if type(expr((g:=gcd(p,dp))))=DOM_INT then 
       userinfo(2, "Polynomial found to be squarefree");
       return([p,1]);  
    else w:=divide(p,g,Exact); 
         z:=divide(dp,g,Exact);
         if degree(z,x)=0 then 
            return([w,d]); 
         elif type((dd:=d/degree(w,x)))=DOM_INT then
	      userinfo(4,"Checking whether polynomial is a power");
              if _power(w,dd)=p then 
		 userinfo(2,"Polynomial is a power");
                 return([w,dd]); 
              end_if;
         end_if;
         z:=z-polylib::Dpoly([1],w); // diff(w,x) 
         qfree:=[]; 
         for i from 1 to d do 
             userinfo(4,"Looking for factors of multiplicity ".expr2text(i));
             if iszero(z) then 
                return(append(qfree,w,i));
             else g:=gcd(w,z);
                  w:=divide(w,g,Exact);
                  z:=divide(z,g,Exact)-polylib::Dpoly([1],w); // diff(w,x) 
                  if type(expr(g))<>DOM_INT then 
                     qfree:=append(qfree,g,i);
                  end_if;
             end_if;
         end_for;
    end_if;
end_proc:

