/*--
faclib::set_b -- choose a set of evaluation point of x2..xn randomly, they must
                 satisfy the conditions given by P. S. Wang, "An improved
                 multivariate polynomial factoring algorithm", Math. Comp. 32,
                 page 1215-1231, (1978), the algorithm is also from the above
                 reference.  Output is given in form: the univariate polynomial
                 of input polynomial in x1 evaluated at x2=a2,...,xn=an, the
                 icontent of above, [x2=a2,..,xn=an], a list of integer numbers
                 (they are the values of factors of lcoeff(input polynomial in
                 x1) at above points).

faclib::set_b(p,bn,lfs,lcont,tt)
p - a primitive square free multivariate polynomial in Z[x1..xn]
bn - a list of equations [x2=a2,..,xn=an], representing an evaluation
     homomorphism, mathematically viewed as the idea I=<x2-a2,..,xn-an>
lfs - a list of polynomials, they are the factors of lcoeff(p[x1])
      factorization
lcont - an integer number, it is the icontent of lcoeff(p(x1))
tt - a polynomial in Z[x2..xn], it is the tcoeff(p(x1))

faclib::set_b use faclib::Rn, faclib::Rgb, and faclib::Rb as global variables
--*/

faclib::set_b:=
proc(p,bn,lfs,lcont,tt)
  local bb, elfs, ep, d, fi, i, j, q, ucont;
begin
  sysassign(faclib::Rn, faclib::Rn+1);
  if faclib::Rn mod 7=0 then
    sysassign(faclib::Rgb, 2*faclib::Rgb+1);
    faclib::rb(faclib::Rgb);
  end_if;
  bb:=map(bn,proc(xx)
             begin
               subsop(xx,2=faclib::Rb())
             end_proc);
  userinfo(3,"Evaluation points: ".expr2text(op(bb)));
  elfs:=map(lfs,subs,bb);
  userinfo(10, "Evaluating the factors of the leading coefficient gives  ".
           expr2text(elfs));
  // 0, 1, and 2 have the higher possibility to lead failure of the following 
  // checking the evaluation of the factors of leading coefficient, and the   
  // evaluation of tt=0 lead p(x1,a2..an) has factor only with one term, it   
  // is a bad case of lifting, so have the following conditions               
  if bb<>bn and nops(elfs)=nops({op(map(elfs,abs))} minus {0,1,2,lcont}) \
    and subs(tt,bb)<>0 then
    ep:=evalp(p,op(bb));
    ucont:=icontent(ep);
    if elfs<>[] then
      // check if every factor has a different prime divisor 
      fi:=stdlib::ifactor(ucont*lcont, UsePrimeTab);
      d[1]:={op(fi,2*i)$i=1..(nops(fi)-1)/2};
      userinfo(20, if nops(d[1])> 0 then
                     "Prime factors of content are ".expr2text(op(d[1]))
                   else
                     "Content is 1"
                   end_if
                     );
      for j from 2 to nops(elfs)+1 do
        fi:=stdlib::ifactor(elfs[j-1], UsePrimeTab);
        q:={op(fi,2*i)$i=1..(nops(fi)-1)/2};
        userinfo(20, "Prime factors are ".expr2text(q));
        for i from 1 to j-1 do
          q:=q minus d[i];
          if q={} then
            userinfo(20, "No new prime factors, restarting");
            return(faclib::set_b(p,bb,lfs,lcont,tt));
          end_if;
        end_for;
        userinfo(20, "New prime factors:  ".expr2text(op(q)));
        d[j]:=q;
      end_for;
    end_if;
    ep:=multcoeffs(ep,1/ucont);
    // check if p(x1,a2..an) is square free 
    if type(expr(gcd(ep,polylib::Dpoly([1],ep))))=DOM_INT then
      userinfo(20, "Homomorphic image is squarefree ");
      return(ep,ucont,bb,elfs)
    else
      userinfo(20, "Homomorphic image is not squarefree, restarting ");
    end_if;
  end_if;
  faclib::set_b(p,bb,lfs,lcont,tt);
end_proc:
    
