//    

// kg, 16/12/94 

/*++
faclib::sqrfree_poly -- square-free factorization of polynomial

faclib::sqrfree_poly(p)

p - polynomial over UFD of characteristic 0 or finite field

faclib::sqrfree_poly(p) returns a list of the form [c,f1,e1,...,fn,en]
where c is the contents of p and the fi are the square-free factors
of order ei of p. Each fi is of the same type as p.

The type of the polynomial p is not checked (see sqrfree).
++*/

faclib::sqrfree_poly:=
proc(p)
  local l, f, c, i, j, X, T, ff, n, m, newp;
begin
  X:= op(p,2);
  T:= op(p,3);
    
  // is T an UFD of char. 0 or a finite field? 
  if domtype(T) = DOM_DOMAIN then
    if T::characteristic = FAIL then
      ff:= FALSE	// assume that T is UFD of char.0 
    elif T::characteristic = 0 then
      ff:= FALSE
    else
      ff:= TRUE;
      // should be representation-independent 
      if T::hasProp(Dom::IntegerMod) then
        n:= T::size;
        m:= 1;
      elif T::hasProp(Dom::GaloisField) then
        n:= T::characteristic;
        m:= T::degreeOverPrimeField;
      elif T::hasProp(Dom::AlgebraicExtension) then
        n:= T::characteristic;
        m:=T::degreeOverPrimeField;
      else
        error("unknown field")
      end_if
    end_if
  elif T = hold(Expr) then
    ff:= FALSE;
    // handle case of complex coeffs
//  if not testtype(p, Type::PolyOf(Type::Rational)) then
    if map({coeff(p)}, domtype) minus {DOM_INT, DOM_RAT} <> {} then
      l:=polylib::makerat(p);
      newp:=op(l,1);
      f:=faclib::sqrfree_poly(newp);
      // denominator must be a unit
      f[1]:=expr(f[1])/expr(op(l,2));
      f:=[subs(f[1], op(l,3)),
          (poly(subs(expr(f[2*i]), op(op(l,3))), op(p,2..3)), f[2*i+1])
          $i=1..nops(f) div 2];
      // remove constant factors 
      i:=2;
      while i<=nops(f) do
        if degree(f[i])=0 then
          f[1]:=f[1]*expr(f[i])^(f[i+1]);
          delete f[i+1];
          delete f[i]
        else
          i:=i+2
        end_if
      end_while;
      return(f)
    end_if
  else // must be IntMod-poly 
    ff:= TRUE;
    n:= op(p,[3,1]);
    m:= 1;
  end_if;
  
  f:= faclib::pre_factor(p);
  l:= [f[1]];
  
  for i from 2 to nops(f) step 2 do
    if nterms(f[i]) = 1 or degree(f[i]) <= 1 then
      l:= append(l, poly(f[i],X,T), f[i+1])
    else
      if ff then
        c:= lcoeff(f[i]);
        l[1]:= l[1]*c;
        if nops(op(f[i],2)) > 1 then
          c:= faclib::sqrfrmv(multcoeffs(f[i], 1/c), n, m)
        else
          c:= faclib::sqrfree_ffield(multcoeffs(f[i], 1/c), n, m);
        end_if
      else
        c:= faclib::sqrfree_yun(f[i]);
        // Yun's algorithm returns the factorization modulo an unit 
        // make factors primitive
        for j from 1 to nops(c) step 2 do
          c[j]:=polylib::primpart(c[j])
        end_for;
        n:= _mult(_power(c[2*j-1], c[2*j]) $ j=1..(nops(c) div 2));
        l[1]:= l[1] * lcoeff(divide(f[i], n, Exact));
      end_if;
      l:= append(l, (poly(c[2*j-1],X,T), c[2*j]*f[i+1])
                 $ j=1..(nops(c) div 2))
    end_if
  end_for;
    
  l
end_proc:

// end of file 
