/* differences with gcdlib::univ_mod_gcd:
  (1) it normalizes the result
  (2) deals only the special case where b=0 (necessary)
  (3) does not normalize input polynomials
*/
faclib::univ_mod_gcd := proc(a,b)
local t;
begin
    if iszero(b) then return(a) end_if;
    repeat
	     t:= divide(a, b, Rem);
             if iszero(t) then return(multcoeffs(b, 1/lcoeff(b))) end_if;
	     a:= b;
	     b:= t;
    until FALSE end_repeat;
end_proc:

